/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPublicPropertyModifierCanBeOmittedInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpPublicPropertyModifierCanBeOmittedInspection
extends PhpInspection
implements DumbAware {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpField(Field field) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                this.checkField(field);
            }

            public void visitPhpParameter(Parameter parameter) {
                if (!(parameter instanceof Field)) {
                    return;
                }
                this.checkField((Field)((Object)parameter));
            }

            private final void checkField(Field field) {
                PhpModifier phpModifier = field.getModifier();
                Intrinsics.checkNotNullExpressionValue((Object)phpModifier, (String)"getModifier(...)");
                PhpModifier modifier = phpModifier;
                if (!modifier.isPublic() || modifier.getSetAccess() == null) {
                    return;
                }
                PsiElement psiElement = FieldImpl.getVisibilityPsi(field);
                if (psiElement == null) {
                    return;
                }
                PsiElement visibility = psiElement;
                PhpModifier.Access access = modifier.getSetAccess();
                Intrinsics.checkNotNull((Object)((Object)access));
                if (access.isPublic()) {
                    return;
                }
                this.$holder.problem(visibility, PhpBundle.message("inspection.visibility.modifier.can.be.removed", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(visibility)).register();
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }
}

