/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpImmutablePropertyIsWrittenInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                PsiElement parent = fieldReference.getParent();
                boolean returnedFromReturnByRefFunction = PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)fieldReference);
                if (!(fieldReference.isWriteAccess() || parent instanceof AssignmentExpression && PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)parent) || parent instanceof PhpUnset || returnedFromReturnByRefFunction)) {
                    return;
                }
                Collection<Field> fields = fieldReference.multiResolveStrict(Field.class);
                if (fields.isEmpty()) {
                    return;
                }
                if (ContainerUtil.exists(fields, field -> !field.isReadonly())) {
                    return;
                }
                if (returnedFromReturnByRefFunction) {
                    holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.write.access.to.readonly.property.outside.declaration.scope.ret.by.ref", new Object[0]), ProblemHighlightType.WARNING, LocalQuickFix.EMPTY_ARRAY);
                    return;
                }
                if (ContainerUtil.all(fields, field -> PhpImmutablePropertyIsWrittenInspection.writeAccessIsNotAllowed(fieldReference, PhpImmutablePropertyIsWrittenInspection.PropertyWriteScope.PRIVATE, field))) {
                    holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.write.access.to.readonly.property.outside.declaration.scope", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection", "buildVisitor"));
    }
}

