/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantAssignmentToPromotedFieldInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantAssignmentToPromotedFieldInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethod(Method method) {
                if (method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                List promotedFields = ContainerUtil.filter((Object[])method.getParameters(), Parameter::isPromotedField);
                if (promotedFields.isEmpty()) {
                    return;
                }
                PhpRedundantAssignmentToPromotedFieldInspection.processAssignmentsDuplicatingPromotedField(method, promotedFields, (instruction, assignment) -> {
                    PsiElement parent = assignment.getParent();
                    boolean singleStatement = PhpRedundantAssignmentToPromotedFieldInspection.isSingleStatement(parent);
                    PhpDeleteElementQuickFix fix = singleStatement ? new PhpDeleteElementQuickFix(parent, PhpBundle.message("remove.assignment", new Object[0])) : null;
                    holder.problem((PsiElement)(singleStatement ? parent : assignment), PhpBundle.message("inspection.message.redundant.assignment", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).maybeFix((ModCommandAction)fix).register();
                });
            }
        };
    }

    public static boolean isSingleStatement(@Nullable PsiElement parent) {
        return parent instanceof Statement && parent.getChildren().length == 1;
    }

    public static void processAssignmentsDuplicatingPromotedField(Method constructor, Collection<Parameter> parametersToCheck, final BiConsumer<PhpAccessFieldByVariableInstruction, AssignmentExpression> consumer) {
        final HashSet promotedFieldsSet = new HashSet(ContainerUtil.map2Set(parametersToCheck, Parameter::getName));
        PhpControlFlowUtil.processSuccessors(constructor.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                this.removePromotedFieldNameIfChanged(instruction, instruction.getVariableName());
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                this.removePromotedFieldNameIfChanged(instruction, PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction));
                return super.processArrayAccessInstruction(instruction);
            }

            @Override
            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                if (instruction.getAccess().isWrite() && PhpLangUtil.isThisReference(instruction.getVariableName()) && promotedFieldsSet.contains(instruction.getFieldName())) {
                    AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                    if (assignment == null) {
                        return true;
                    }
                    Variable assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getValue(), Variable.class);
                    if (assignedVariable != null && PhpLangUtil.equalsVariableNames(assignedVariable.getName(), instruction.getFieldName())) {
                        consumer.accept(instruction, assignment);
                    }
                }
                return true;
            }

            private void removePromotedFieldNameIfChanged(PhpAccessInstruction instruction, @Nullable CharSequence name) {
                if (name == null) {
                    return;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWrite() || access.isReadRef()) {
                    promotedFieldsSet.remove(name);
                }
            }
        });
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpRedundantAssignmentToPromotedFieldInspection", "buildVisitor"));
    }
}

