/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpRedundantFinalModifierInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "intellij.php.impl"})
public final class PhpRedundantFinalModifierInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpField(Field field) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                    if (!(field instanceof FieldImpl)) {
                        return;
                    }
                    if (((FieldImpl)field).isConstant()) {
                        return;
                    }
                    PhpModifier phpModifier = ((FieldImpl)field).getModifier();
                    Intrinsics.checkNotNullExpressionValue((Object)phpModifier, (String)"getModifier(...)");
                    PhpModifier modifier = phpModifier;
                    if (!modifier.isFinal() || modifier.getSetAccess() != PhpModifier.Access.PRIVATE) {
                        return;
                    }
                    PhpClassFieldsList phpClassFieldsList = ((FieldImpl)field).getParentList();
                    if (phpClassFieldsList == null) {
                        return;
                    }
                    PhpClassFieldsList list = phpClassFieldsList;
                    PhpModifierList phpModifierList = list.getModifierList();
                    if (phpModifierList == null) {
                        return;
                    }
                    PhpModifierList modifierList = phpModifierList;
                    PsiElement psiElement = PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.kwFINAL);
                    if (psiElement == null) break block5;
                    PsiElement psiElement2 = psiElement;
                    ProblemsHolder problemsHolder = this.$holder;
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    problemsHolder.problem(it, PhpBundle.message("php.inspection.redundant.final.modifier", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(it)).register();
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }
}

