/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantReadonlyModifierInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantReadonlyModifierInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClassFieldsList(PhpClassFieldsList classFieldsList) {
                PhpModifierList modifierList = classFieldsList.getModifierList();
                if (modifierList != null) {
                    this.doCheck((PsiElement)modifierList);
                }
            }

            @Override
            public void visitPhpParameter(Parameter parameter) {
                if (parameter.isPromotedField()) {
                    this.doCheck(parameter);
                }
            }

            private void doCheck(@NotNull PsiElement element) {
                PhpClass containingClass;
                PsiElement readonlyKeyword;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((readonlyKeyword = FieldImpl.getReadonlyKeyword(element)) != null && (containingClass = PhpPsiUtil.getParentOfClass(element, PhpClass.class)) != null && containingClass.isReadonly()) {
                    PsiElement visibilityModifier = PhpPsiUtil.getChildOfType(readonlyKeyword.getParent(), PhpTokenTypes.tsVISIBILITY_MODIFIERS);
                    holder.registerProblem(readonlyKeyword, PhpBundle.message("inspection.message.readonly.modifier.redundant", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new PhpDeleteReadonlyQuickFix(visibilityModifier == null)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/PhpRedundantReadonlyModifierInspection$1", "doCheck"));
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP820;
    }

    public static void deleteRedundantReadonlyModifier(@NotNull Project project, PsiElement readonlyModifier, boolean makePublic) {
        if (project == null) {
            PhpRedundantReadonlyModifierInspection.$$$reportNull$$$0(1);
        }
        if (makePublic) {
            PhpModifierList modifierList = PhpPsiElementFactory.createModifierList(project, PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC);
            PsiElement publicKw = PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.kwPUBLIC);
            assert (publicKw != null);
            readonlyModifier.replace(publicKw);
        } else {
            readonlyModifier.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRedundantReadonlyModifierInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRedundantReadonlyModifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpDeleteReadonlyQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myMakePublic;

        private PhpDeleteReadonlyQuickFix(boolean makePublic) {
            this.myMakePublic = makePublic;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myMakePublic ? PhpBundle.message("intention.family.name.replace.readonly.with.public", new Object[0]) : PhpBundle.message("intention.family.name.delete.readonly", new Object[0]);
            if (string == null) {
                PhpDeleteReadonlyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpDeleteReadonlyQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpDeleteReadonlyQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpDeleteReadonlyQuickFix.$$$reportNull$$$0(3);
            }
            PhpRedundantReadonlyModifierInspection.deleteRedundantReadonlyModifier(project, element, this.myMakePublic);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRedundantReadonlyModifierInspection$PhpDeleteReadonlyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRedundantReadonlyModifierInspection$PhpDeleteReadonlyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

