/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpSafeDeleteCallerChooserBase;
import com.jetbrains.php.lang.inspections.PhpUnusedPrivateMethodInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JTree;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class PhpRemoveMethodWithPropagationQuickFix
implements LocalQuickFix {
    private static final PhpClassMember[] EMPTY_FUNCTIONS = new PhpClassMember[0];

    PhpRemoveMethodWithPropagationQuickFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.remove", "method");
        if (string == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method method;
        if (project == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(2);
        }
        if ((method = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), false, Method.class)) == null) {
            return;
        }
        HashSet<PhpClassMember> methodsToDelete = new HashSet<PhpClassMember>();
        methodsToDelete.add(method);
        List<PhpClassMember> unusedCalls = PhpSafeDeleteMemberNode.doComputeUnusedCalls(method);
        if (!unusedCalls.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                methodsToDelete.addAll(unusedCalls);
            } else {
                CallerChooserBase<PhpClassMember> callerChooser = PhpRemoveMethodWithPropagationQuickFix.createCallerChooser(project, method, methodsToDelete);
                TreeUtil.expand((JTree)callerChooser.getTree(), (int)2);
                if (!callerChooser.showAndGet()) {
                    return;
                }
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)method)) {
            return;
        }
        WriteAction.run(() -> methodsToDelete.forEach(element -> {
            if (element instanceof Method) {
                PhpUnusedPrivateMethodInspection.BATCH_FIX.remove((PsiElement)element);
            } else {
                PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)element);
            }
        }));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(4);
        }
        Method method = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), false, Method.class);
        PhpUnusedPrivateMethodInspection.BATCH_FIX.remove(method);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    private static CallerChooserBase<PhpClassMember> createCallerChooser(final @NotNull Project project, Method method, Collection<PhpClassMember> methodsToDelete) {
        if (project == null) {
            PhpRemoveMethodWithPropagationQuickFix.$$$reportNull$$$0(6);
        }
        return new PhpSafeDeleteCallerChooserBase<PhpClassMember>((PhpClassMember)method, project, PhpBundle.message("dialog.title.select.methods.to.propagate.safe.delete", new Object[0]), methodsToDelete::addAll){

            @Override
            protected MemberNodeBase<PhpClassMember> createNode(PhpClassMember element, HashSet<PhpClassMember> called, Runnable cancelCallback) {
                return new PhpSafeDeleteMemberNode(project, element, called, cancelCallback);
            }

            protected PhpClassMember[] findDeepestSuperMethods(PhpClassMember method1) {
                return EMPTY_FUNCTIONS;
            }
        };
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean resolvedToCandidates(PhpReference reference, Collection<PhpClassMember> candidates) {
        ResolveResult[] resolveResults = reference.multiResolve(false);
        if (resolveResults.length == 0) {
            return false;
        }
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof PhpClassMember && candidates.contains(element)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRemoveMethodWithPropagationQuickFix";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRemoveMethodWithPropagationQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCallerChooser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpSafeDeleteMemberNode
    extends MemberNodeBase<PhpClassMember> {
        protected PhpSafeDeleteMemberNode(Project project, PhpClassMember method, Set<PhpClassMember> called, Runnable cancelCallback) {
            super((PsiElement)method, called, project, cancelCallback);
        }

        protected MemberNodeBase<PhpClassMember> createNode(PhpClassMember caller, HashSet<PhpClassMember> called) {
            return new PhpSafeDeleteMemberNode(this.myProject, caller, called, this.myCancelCallback);
        }

        protected List<PhpClassMember> computeCallers() {
            PhpClassMember member = (PhpClassMember)this.getMember();
            return member instanceof Method ? PhpSafeDeleteMemberNode.doComputeUnusedCalls((Method)member) : Collections.emptyList();
        }

        protected void customizeRendererText(ColoredTreeCellRenderer renderer2) {
            PhpClassMember member = (PhpClassMember)this.getMember();
            if (member instanceof Method) {
                PhpMethodNode.doRenderMethod(renderer2, (Function)((Object)member), this.isEnabled(), PhpFunctionCodeGenerator.DECLARATION);
            } else if (member instanceof Field) {
                PhpMethodNode.doAppend(renderer2, this.isEnabled(), "$" + member.getName());
            }
        }

        @NotNull
        private static List<PhpClassMember> doComputeUnusedCalls(Method member) {
            List<PhpClassMember> list = PhpSafeDeleteMemberNode.collectUsedMemberReferences(member).stream().filter(f -> member != f).distinct().filter(f -> PhpSafeDeleteMemberNode.usedOnlyIn(f, member)).collect(Collectors.toList());
            if (list == null) {
                PhpSafeDeleteMemberNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static boolean usedOnlyIn(PhpClassMember usage, Method usedOnlyIn) {
            PhpClass clazz;
            if (usage.getModifier().getAccess().isPrivate() && (clazz = usage.getContainingClass()) != null && usedOnlyIn != null && usedOnlyIn.getContainingClass() == clazz) {
                return !PhpUnusedPrivateMethodInspection.hasRefs(usage, usedOnlyIn, clazz);
            }
            return false;
        }

        @NotNull
        private static Collection<PhpClassMember> collectUsedMemberReferences(Method member) {
            LinkedHashSet<PhpClassMember> res = new LinkedHashSet<PhpClassMember>();
            PhpClass aClass = member.getContainingClass();
            if (aClass == null) {
                List<PhpClassMember> list = Collections.emptyList();
                if (list == null) {
                    PhpSafeDeleteMemberNode.$$$reportNull$$$0(1);
                }
                return list;
            }
            List privateMembers = ((StreamEx)StreamEx.of((Object[])aClass.getOwnMethods()).append((Object[])aClass.getOwnFields()).filter(m -> m.getModifier().getAccess().isPrivate())).toList();
            Consumer<PhpReference> consumer = reference -> {
                for (ResolveResult result : reference.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (!(element instanceof PhpClassMember)) continue;
                    res.add((PhpClassMember)element);
                }
            };
            PhpSafeDeleteMemberNode.processCandidatesUsagesInMethod(member, privateMembers, consumer);
            LinkedHashSet<PhpClassMember> linkedHashSet = res;
            if (linkedHashSet == null) {
                PhpSafeDeleteMemberNode.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }

        public static void processCandidatesUsagesInMethod(Method method, final Collection<PhpClassMember> candidates, final Consumer<PhpReference> consumer) {
            PhpControlFlowUtil.processFlow(method.getControlFlow(), new PhpControlFlowUtil.PhpClosureVisitingInstructionProcessor(){

                @Override
                public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                    FunctionReference reference = instruction.getFunctionReference();
                    if (!(reference instanceof MethodReference) || !ContainerUtil.exists((Iterable)candidates, m -> m instanceof Method && PhpLangUtil.equalsMethodNames(reference.getName(), m.getName()))) {
                        return true;
                    }
                    if (PhpRemoveMethodWithPropagationQuickFix.resolvedToCandidates(reference, candidates)) {
                        consumer.accept(reference);
                    }
                    return true;
                }

                @Override
                public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                    return this.doCheckFieldReference(instruction, instruction.getFieldName());
                }

                @Override
                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    return this.doCheckFieldReference(instruction, instruction.getFieldName());
                }

                private boolean doCheckFieldReference(PhpInstruction instruction, CharSequence name) {
                    if (!ContainerUtil.exists((Iterable)candidates, f -> f instanceof Field && PhpLangUtil.equalsFieldNames(f.getName(), name))) {
                        return true;
                    }
                    FieldReference reference = (FieldReference)instruction.getAnchor();
                    if (reference != null && PhpRemoveMethodWithPropagationQuickFix.resolvedToCandidates(reference, candidates)) {
                        consumer.accept(reference);
                    }
                    return true;
                }
            });
        }

        protected Condition<PhpClassMember> getFilter() {
            return member -> !((PhpClassMember)this.getMember()).equals(member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/inspections/PhpRemoveMethodWithPropagationQuickFix$PhpSafeDeleteMemberNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doComputeUnusedCalls";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectUsedMemberReferences";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

