/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModTemplateBuilder;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRenameWrongReferenceQuickFix
extends PsiUpdateModCommandAction<PhpReference> {
    private static final String CURRENT_VAR = "CURRENT_VAR";
    private static final String OTHER_VAR = "OTHER_VAR";

    public PhpRenameWrongReferenceQuickFix(@NotNull PhpReference element) {
        if (element == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PhpReference reference, @NotNull ModPsiUpdater updater) {
        PhpScopeHolder scopeHolder;
        if (context == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(3);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)reference)) == null) {
            return;
        }
        List sameReferences = ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)scopeHolder, reference.getClass()), r -> r.getClass() == reference.getClass() && PhpRenameWrongReferenceQuickFix.isSameReference(r, reference));
        PsiElement nameNode = PhpRenameWrongReferenceQuickFix.extractElementToRename(reference);
        if (nameNode == null) {
            return;
        }
        ModTemplateBuilder builder2 = updater.templateBuilder();
        ConstantNode expression = new ConstantNode(StringUtil.notNullize((String)reference.getName())).withLookupStrings(PhpRenameWrongReferenceQuickFix.getClassReferenceMembersNames(reference));
        for (PhpReference ref : sameReferences) {
            PsiElement element = PhpRenameWrongReferenceQuickFix.extractElementToRename(ref);
            if (element == null) continue;
            if (ref.equals(reference)) {
                builder2.field(element, CURRENT_VAR, (Expression)expression);
                continue;
            }
            builder2.field(element, OTHER_VAR, CURRENT_VAR, false);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.rename.wrong.reference.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String[] getClassReferenceMembersNames(PhpReference originalReference) {
        PhpExpression classReference;
        PhpExpression phpExpression = classReference = originalReference instanceof MemberReference ? ((MemberReference)originalReference).getClassReference() : null;
        if (classReference == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        PhpIndex index = PhpIndex.getInstance(classReference.getProject());
        return (String[])((StreamEx)((StreamEx)StreamEx.of(classReference.getGlobalType().getTypes()).filter(PhpLangUtil::isFqn)).flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).flatMap(aClass -> Arrays.stream(originalReference instanceof MethodReference ? aClass.getOwnMethods() : aClass.getOwnFields())).map(rec$ -> ((PhpNamedElement)rec$).getName()).distinct()).toArray(String.class);
    }

    @Nullable
    private static PsiElement extractElementToRename(PhpReference reference) {
        ASTNode node = reference.getNameNode();
        return node != null ? node.getPsi() : null;
    }

    private static boolean isSameReference(PhpReference first, PhpReference second) {
        PsiElement f = first.getFirstChild();
        PsiElement s = second.getFirstChild();
        while (f != null) {
            if (s == null) {
                return true;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)f, (PsiElement)s)) {
                return false;
            }
            if (f.getNode() == first.getNameNode() || s.getNode() == second.getNode()) {
                return true;
            }
            f = PhpPsiUtil.getNextSiblingIgnoreWhitespace(f, true);
            s = PhpPsiUtil.getNextSiblingIgnoreWhitespace(s, true);
        }
        return s != null;
    }

    public static LocalQuickFix @NotNull [] appendQuickFix(@NotNull PhpReference reference, LocalQuickFix[] fixes) {
        if (reference == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(5);
        }
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)LocalQuickFix.from((ModCommandAction)new PhpRenameWrongReferenceQuickFix(reference)));
        if (localQuickFixArray == null) {
            PhpRenameWrongReferenceQuickFix.$$$reportNull$$$0(6);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpRenameWrongReferenceQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpRenameWrongReferenceQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

