/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpSillyAssignmentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSillyAssignmentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PsiElement variable = PhpPsiUtil.unparenthesize((PsiElement)assignmentExpression.getVariable());
                PsiElement value = PhpPsiUtil.unparenthesize((PsiElement)assignmentExpression.getValue());
                if (variable instanceof Variable && value instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)variable).getNameCS(), ((Variable)value).getNameCS()) || variable != null && value != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)value)) {
                    holder.problem((PsiElement)assignmentExpression, PhpSillyAssignmentInspection.getErrorOnTheFly()).fix((ModCommandAction)new PhpDeleteElementQuickFix(assignmentExpression.getParent(), PhpBundle.message("delete.assignment", new Object[0]))).register();
                }
            }
        };
    }

    @InspectionMessage
    public static String getErrorOnTheFly() {
        return PhpBundle.message("inspection.silly.assignment.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpSillyAssignmentInspection", "buildVisitor"));
    }
}

