/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpTooLongMemberReferenceChainInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTooLongMemberReferenceChainInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.doCheck(fieldReference, fieldReference.getClassReference());
            }

            @Override
            public void visitPhpCallableMethod(PhpCallableMethod reference) {
                this.doCheck(reference, reference.getClassReference());
            }

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                this.doCheck(reference, reference.getClassReference());
            }

            private void doCheck(PhpReference fieldReference, PhpExpression classReference) {
                ASTNode nameNode = fieldReference.getNameNode();
                if (nameNode != null && MemberReferenceImpl.getDepth(classReference) == 100) {
                    holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.message.call.chain.too.long.to.analyse.break.it.into.fragments.up.to.calls", 100), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpTooLongMemberReferenceChainInspection", "buildVisitor"));
    }
}

