/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public final class PhpTooManyParametersInspection
extends PhpInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 5;
    public int limit = 5;
    public boolean ignoreConstructors = true;

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"limit", (String)PhpBundle.message("inspection.too.many.parameters.max.number.of.parameters", new Object[0]), (int)1, (int)100), OptPane.checkbox((String)"ignoreConstructors", (String)PhpBundle.message("inspection.too.many.parameters.ignore.constructors", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpTooManyParametersInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTooManyParametersInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                if (function instanceof Method) {
                    return;
                }
                if (function.getParameters().length > PhpTooManyParametersInspection.this.limit) {
                    PsiElement kwFunction;
                    PsiElement nameIdentifier = function.getNameIdentifier();
                    if (nameIdentifier != null) {
                        holder.registerProblem(nameIdentifier, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
                    } else if (function.isClosure() && (kwFunction = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwFUNCTION)) != null && kwFunction.getContainingFile() == holder.getFile()) {
                        holder.registerProblem(kwFunction, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitPhpClass(PhpClass clazz) {
                Method[] methods;
                for (Method it : methods = clazz.getOwnMethods()) {
                    PhpTooManyParametersInspection.this.processMethod(it, holder);
                }
            }
        };
    }

    private void processMethod(Method method, ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (this.ignoreConstructors && PhpRefactoringUtil.isElementConstructor(method)) {
            return;
        }
        if (method.getParameters().length > this.limit && (nameIdentifier = method.getNameIdentifier()) != null) {
            holder.registerProblem(nameIdentifier, PhpTooManyParametersInspection.getMessage(), new LocalQuickFix[0]);
        }
    }

    @InspectionMessage
    public static String getMessage() {
        return PhpBundle.message("inspection.too.many.parameters", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpTooManyParametersInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpTooManyParametersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

