/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.array.PhpConvertToShortArraySyntaxIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpTraditionalSyntaxArrayLiteralInspection
extends PhpInspection {
    public static LocalQuickFix[] createFixes() {
        return new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpConvertToShortArraySyntaxIntention())};
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTraditionalSyntaxArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                PsiElement arrayKw;
                PhpLanguageLevel preferableLanguageLevel;
                if (!expression.isShortSyntax() && PhpTraditionalSyntaxArrayLiteralInspection.isTopMost(expression) && (preferableLanguageLevel = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel()).hasFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX) && PhpPsiUtil.isOfType(arrayKw = expression.getFirstChild(), PhpTokenTypes.kwARRAY)) {
                    holder.registerProblem(arrayKw, PhpTraditionalSyntaxArrayLiteralInspection.getProblemDescription(), PhpTraditionalSyntaxArrayLiteralInspection.createFixes());
                }
            }
        };
    }

    private static boolean isTopMost(ArrayCreationExpression expression) {
        return PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)element -> element instanceof ArrayCreationExpression && !((ArrayCreationExpression)element).isShortSyntax()), Statement.INSTANCEOF) == null;
    }

    @InspectionMessage
    private static String getProblemDescription() {
        return PhpBundle.message("inspection.traditional.syntax.array.literal.detected", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpTraditionalSyntaxArrayLiteralInspection", "buildVisitor"));
    }
}

