/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstantReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUndefinedClassConstantInspection
extends PhpUndefinedMemberInspection {
    private static final AddConstantDeclarationQuickFix FIX = new AddConstantDeclarationQuickFix();
    private static final LocalQuickFix[] CLASS_FIXES = new LocalQuickFix[]{FIX};
    private static final LocalQuickFix[] ENUM_FIXES = new LocalQuickFix[]{FIX, new PhpAddEnumCaseDeclarationQuickFix()};
    private static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("defined");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                this.checkConstantReference(reference, reference.getClassReference(), classReference -> !PhpUndefinedFieldInspection.noResolvedDeclarationExists(classReference));
            }

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                if (!PhpPsiUtil.classConstantReferenceViaVariable(fieldReference)) {
                    return;
                }
                this.checkConstantReference(fieldReference, fieldReference.getClassReference(), PhpUndefinedClassConstantInspection::classReferenceIsResolved);
            }

            private void checkConstantReference(MemberReference reference, PhpExpression classReference, Predicate<PhpReference> classReferenceIsResolved) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null || nameNode.getElementType() == PhpTokenTypes.kwCLASS) {
                    return;
                }
                if (classReference instanceof PhpReference && classReferenceIsResolved.test((PhpReference)classReference) && reference.multiResolve(false).length == 0) {
                    Ref canBeUndefined = new Ref((Object)false);
                    Ref canBeDefined = new Ref((Object)false);
                    PhpUndefinedClassConstantInspection.performDfaReachability(reference, (PhpReference)classReference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    if (((Boolean)canBeDefined.get()).booleanValue() && !((Boolean)canBeUndefined.get()).booleanValue()) {
                        return;
                    }
                    PhpType type = classReference.getGlobalType();
                    String template = isOnTheFly ? PhpBundle.message("constant.ref.not.found.in", type.toStringRelativized(reference.getNamespaceName())) : PhpBundle.message("inspection.message.constant.ref.not.found", new Object[0]);
                    PhpClass aClass = PhpQuickFixBase.resolveClass(reference, false);
                    LocalQuickFix[] fixes = aClass != null ? (aClass.isEnum() ? ENUM_FIXES : CLASS_FIXES) : LocalQuickFix.EMPTY_ARRAY;
                    holder.registerProblem(nameNode.getPsi(), template, fixes);
                }
            }
        };
    }

    public static void performDfaReachability(MemberReference reference, PhpReference classReference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        String fqn;
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        String name = reference.getName();
        String string = fqn = classReference instanceof ClassConstantReferenceImpl ? classReference.getSignature() : classReference.getFQN();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, canBeDefined, canBeUndefined, fqn + "::" + name, DF_ANALYZER);
        }
    }

    private static boolean classReferenceIsResolved(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpUndefinedClassConstantInspection.$$$reportNull$$$0(1);
        }
        PhpIndex index = PhpIndex.getInstance(reference.getProject());
        return ContainerUtil.exists(reference.getGlobalType().getTypes(), type -> !index.getAnyByFQN((String)type).isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "classReferenceIsResolved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddConstantDeclarationQuickFix
    extends ModCommandQuickFix {
        AddConstantDeclarationQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("add.constant.declaration.quick.fix.text", new Object[0]);
            if (string == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpClass klass;
            if (project == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if ((klass = AddConstantDeclarationQuickFix.resolveTargetClass(descriptor)) == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    AddConstantDeclarationQuickFix.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            PsiElement problem = descriptor.getPsiElement();
            String constantName = problem.getText();
            PsiElement member = this.createMemberToInsert(klass, constantName);
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)klass, (writableClass, updater) -> {
                PsiElement semicolon;
                PsiElement inserted = PhpCodeEditUtil.insertClassMember(writableClass, member);
                if (this.shouldNavigateToCase(inserted) && (semicolon = PhpPsiUtil.getChildOfType(inserted, PhpTokenTypes.opSEMICOLON)) != null) {
                    updater.moveCaretTo(semicolon);
                }
            });
            if (modCommand == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        @Nullable
        private static PhpClass resolveTargetClass(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                AddConstantDeclarationQuickFix.$$$reportNull$$$0(6);
            }
            PsiElement element = descriptor.getPsiElement();
            MemberReference reference = PhpPsiUtil.getParentOfClass(element, false, MemberReference.class);
            return PhpQuickFixBase.resolveClass(reference, false);
        }

        protected boolean shouldNavigateToCase(PsiElement inserted) {
            return PhpPsiUtil.isOfType(inserted, PhpElementTypes.CLASS_CONSTANTS);
        }

        protected PsiElement createMemberToInsert(PhpClass klass, String constantName) {
            Field field = PhpPsiElementFactory.createFromText(klass.getProject(), Field.class, "class c { const " + constantName + " = ;}");
            assert (field != null);
            return field.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$AddConstantDeclarationQuickFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveTargetClass";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpAddEnumCaseDeclarationQuickFix
    extends AddConstantDeclarationQuickFix {
        private PhpAddEnumCaseDeclarationQuickFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = PhpBundle.message("add.enum.declaration.quick.fix.text", new Object[0]);
            if (string == null) {
                PhpAddEnumCaseDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected boolean shouldNavigateToCase(PsiElement inserted) {
            return PhpPsiUtil.getChildOfType(inserted, PhpTokenTypes.opASGN) != null;
        }

        @Override
        protected PsiElement createMemberToInsert(PhpClass klass, String constantName) {
            return PhpPsiElementFactory.createEnumCase(klass.getProject(), constantName, !klass.getBackedEnumType().isEmpty() ? "" : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpUndefinedClassConstantInspection$PhpAddEnumCaseDeclarationQuickFix", "getName"));
        }
    }
}

