/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.inspections.PhpFqnSimpleFunctionDefinedDfaAnalyzer;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpImportClassQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpSwitchLanguageLevelQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.createClass.PhpCreateClassQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpUndefinedClassInspection
extends PhpUndefinedClassInspectionBase {
    public static final PhpReachingDefinitionsDFAnalyzer DF_ANALYZER = new PhpFqnSimpleFunctionDefinedDfaAnalyzer("class_exists");
    private static final Set<String> TAINT_TYPES = Set.of("input", "callable", "unserialize", "include", "eval", "ldap", "sql", "html", "has_quotes", "shell", "ssrf", "file", "cookie", "header", "user_secret", "system_secret");

    @Override
    protected void checkClassResolveResult(PhpReference reference, String name, PsiElement anchor, ResolveResult[] results, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(0);
        }
        if (results.length == 0) {
            if (reference instanceof PhpDocType && (PhpUndefinedClassInspection.isTaintType((PsiElement)reference) || PhpUndefinedClassInspection.isFloatArrayShapeType((PsiElement)reference) || ContainerUtil.exists((Object[])reference.getReferences(), PhpUndefinedClassInspection::hasResolvedTarget))) {
                return;
            }
            if (reference instanceof ClassReference && PhpUndefinedClassInspection.classReferenceIsDfaDefined((ClassReference)reference)) {
                return;
            }
            holder.registerProblem(anchor, PhpBundle.message("inspection.php.undefined.class.description2", new Object[0]), PhpUndefinedClassInspection.getUndefinedClassFixes(anchor, reference, isOnTheFly));
        }
    }

    private static boolean isTaintType(PsiElement element) {
        if (!(element instanceof PhpDocType)) {
            return false;
        }
        return TAINT_TYPES.contains(element.getText());
    }

    private static boolean isFloatArrayShapeType(PsiElement element) {
        if (!(element instanceof PhpDocType)) {
            return false;
        }
        return PhpDocTypeImpl.isFloatArrayShapeType(element.getText());
    }

    public static boolean classReferenceIsDfaDefined(@NotNull ClassReference reference) {
        if (reference == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(1);
        }
        Ref canBeDefined = Ref.create((Object)false);
        Ref canBeUndefined = Ref.create((Object)false);
        PhpUndefinedClassInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
        return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
    }

    private static boolean hasResolvedTarget(PsiReference r) {
        return r instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)r).multiResolve(false).length > 0 : r.resolve() != null;
    }

    public static void processDfaReachability(ClassReference reference, Ref<Boolean> canBeDefined, Ref<Boolean> canBeUndefined) {
        PhpInstruction instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)reference);
        String name = reference.getFQN();
        if (instruction != null && name != null) {
            PhpDFAUtil.performReachingDefinitions(instruction, canBeDefined, canBeUndefined, name, DF_ANALYZER);
        }
    }

    public static PhpInstruction findNearestInstruction(PsiElement anchor) {
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(anchor);
        if (scopeHolder == null) {
            return null;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        while (anchor != null) {
            PhpInstruction instruction = flow.getInstruction(anchor, PhpInstruction.class);
            if (instruction != null) {
                return instruction;
            }
            anchor = anchor.getParent();
        }
        return null;
    }

    private static LocalQuickFix @NotNull [] getUndefinedClassFixes(PsiElement anchor, @NotNull PhpReference reference, boolean isOnTheFly) {
        Collection<PhpClass> candidates;
        if (reference == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(2);
        }
        SmartList fixes = new SmartList();
        if (PhpUndefinedClassInspection.isMixedTypeDeclaration(reference)) {
            fixes.add(PhpSwitchLanguageLevelQuickFix.getInstance(PhpLanguageLevel.PHP800));
        }
        if ((candidates = PhpImportClassQuickFix.INSTANCE.getCandidates(reference.getProject(), reference)).size() > 0 && (isOnTheFly || candidates.size() == 1) && PhpImportClassQuickFix.INSTANCE.isApplicable(anchor)) {
            fixes.add(PhpImportClassQuickFix.INSTANCE);
        }
        if (isOnTheFly && (!PhpCreateClassQuickFix.isClassReferenceToTrait(reference) || PhpLanguageFeature.TRAITS.isSupported(reference.getProject()))) {
            fixes.add(candidates.isEmpty() ? PhpCreateClassQuickFix.INSTANCE : PhpCreateClassQuickFix.LOW_PRIORITY_INSTANCE);
        }
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(3);
        }
        return localQuickFixArray;
    }

    private static boolean isMixedTypeDeclaration(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpUndefinedClassInspection.$$$reportNull$$$0(4);
        }
        if (!(reference.getParent() instanceof PhpTypeDeclaration)) {
            return false;
        }
        return "\\mixed".equalsIgnoreCase(PhpLangUtil.toFQN(reference.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedClassInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndefinedClassFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClassResolveResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "classReferenceIsDfaDefined";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUndefinedClassFixes";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMixedTypeDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

