/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUndefinedMemberInspection
extends PhpInspection {
    public boolean DOWNGRADE_SEVERITY = true;
    public boolean WARN_ON_MIXED = false;

    public boolean isDowngradeSeverity() {
        return this.DOWNGRADE_SEVERITY;
    }

    public boolean isWarnOnMixed() {
        return this.WARN_ON_MIXED;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DOWNGRADE_SEVERITY", (String)PhpBundle.message("inspection.undefined.member.downgrade", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"WARN_ON_MIXED", (String)PhpBundle.message("inspection.undefined.member.warnOnMixed", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUndefinedMemberInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public static boolean isUnresolvedType(Project project, @Nullable PhpExpression classReference, PhpType classReferenceType) {
        PhpType filteredClassReferenceType = classReferenceType.filterUnknown().filterNull();
        if (PhpType.isSubType(PhpType.MIXED, filteredClassReferenceType) || PhpType.isSubType(PhpType.OBJECT, filteredClassReferenceType) || filteredClassReferenceType.isEmpty()) {
            return true;
        }
        PhpIndex index = PhpIndex.getInstance(project);
        PhpType typesWithoutPrimitive = classReferenceType.filterPrimitives().filterOut(PhpType::isPluralType).filter(PhpType.RESOURCE).filter(PhpType.NUMBER);
        if (PhpLangUtil.isThisReference((PsiElement)classReference)) {
            typesWithoutPrimitive = typesWithoutPrimitive.filterOut(PhpType::isAnonymousClass);
        }
        return !typesWithoutPrimitive.isEmpty() && typesWithoutPrimitive.getTypes().stream().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).limit(1L).findAny().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpUndefinedMemberInspection", "getOptionsPane"));
    }
}

