/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpUnitMockMethodReferenceContributor;
import com.jetbrains.php.lang.inspections.PhpRenameWrongReferenceQuickFix;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFunctionInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDeprecatedCallsIn10VersionInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodTagQuickFix;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderTP;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedMethodInspection
extends PhpUndefinedMemberInspection {
    @NotNull
    private static final PhpType PEST_EXPECTATION = PhpType.from("\\Pest\\Expectation");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                this.processPhpReference(reference, reference.getClassReference(), reference.isStatic());
            }

            @Override
            public void visitPhpCallableMethod(PhpCallableMethod reference) {
                this.processPhpReference(reference, reference.getClassReference(), reference.isStatic());
            }

            private void processPhpReference(@NotNull PhpReference reference, @Nullable PhpExpression classReference, boolean isStatic) {
                ASTNode nameNode;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameNode = reference.getNameNode()) == null) {
                    return;
                }
                if (classReference == null) {
                    return;
                }
                PsiElement psi = nameNode.getPsi();
                if (MemberReferenceImpl.chainIsTooDeep(classReference)) {
                    return;
                }
                if (classReference instanceof PhpReference && PhpUndefinedFieldInspection.noResolvedDeclarationExists((PhpReference)classReference)) {
                    return;
                }
                Project project = reference.getProject();
                PhpType type = classReference.getGlobalType();
                if (!PhpUndefinedMethodInspection.this.isWarnOnMixed() && PhpUndefinedMemberInspection.isUnresolvedType(project, classReference, type)) {
                    return;
                }
                if (!PhpUndefinedMethodInspection.this.isWarnOnMixed() && PhpUndefinedMethodInspection.stringDefinedViaClassExists(classReference, type)) {
                    return;
                }
                if (PhpType.intersects(PEST_EXPECTATION, type)) {
                    return;
                }
                Reachability reachability = PhpUndefinedMethodInspection.findDfaReachability(reference, classReference);
                if (reachability == Reachability.DEFINED) {
                    return;
                }
                PhpIndex index = PhpIndex.getInstance(project);
                if (reference.multiResolve(false).length == 0) {
                    String magicMethod;
                    boolean hasMagic = false;
                    if (PhpUndefinedMethodInspection.this.DOWNGRADE_SEVERITY && !(hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, index, magicMethod = isStatic ? "__callStatic" : "__call"))) {
                        hasMagic = PhpUndefinedFieldInspection.isTraitWithMagicMethodsInAllUsages(type, index, magicMethod);
                    }
                    assert (psi != null);
                    holder.registerProblem(this.createDescriptor(psi, reference, reachability, type, hasMagic));
                }
            }

            private ProblemDescriptor createDescriptor(@NotNull PsiElement nameIdentifier, PhpReference methodReference, Reachability reachability, PhpType type, boolean hasMagic) {
                if (nameIdentifier == null) {
                    1.$$$reportNull$$$0(1);
                }
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                if (PhpUndefinedMethodInspection.isQuickFixApplicable(nameIdentifier, isOnTheFly)) {
                    LocalQuickFix[] baseFixes = methodReference instanceof MethodReference ? 1.getBaseFixes(methodReference) : fixes;
                    fixes = PhpRenameWrongReferenceQuickFix.appendQuickFix(methodReference, baseFixes);
                    if (methodReference instanceof MethodReference) {
                        fixes = PhpUndefinedMethodInspection.appendPhpUnit10RemovedAssertionFixes((MethodReference)methodReference, fixes);
                    }
                }
                int reachabilityChoice = reachability == Reachability.MIGHT_BE_DEFINED ? 1 : 0;
                String template = isOnTheFly ? PhpBundle.message("method.is.undefined.in.class", type.toStringRelativized(methodReference.getNamespaceName()), reachabilityChoice) : PhpBundle.message("method.is.undefined", reachabilityChoice);
                ProblemHighlightType highlightType = PhpUndefinedMethodInspection.this.DOWNGRADE_SEVERITY && hasMagic || reachability == Reachability.MIGHT_BE_DEFINED ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                return InspectionManager.getInstance((Project)nameIdentifier.getProject()).createProblemDescriptor(nameIdentifier, template, isOnTheFly, fixes, highlightType);
            }

            private static LocalQuickFix[] getBaseFixes(PhpReference methodReference) {
                LocalQuickFix[] localQuickFixArray;
                if (PhpAddMethodDeclarationQuickFix.INSTANCE.isApplicable((PsiElement)methodReference)) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                    localQuickFixArray2[0] = PhpAddMethodDeclarationQuickFix.INSTANCE;
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[1] = PhpAddMethodTagQuickFix.INSTANCE;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = PhpAddMethodTagQuickFix.INSTANCE;
                }
                return localQuickFixArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameIdentifier";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processPhpReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createDescriptor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Reachability findDfaReachability(@NotNull PhpReference reference, @Nullable PhpExpression classReference) {
        if (reference == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(1);
        }
        PhpInstruction instruction = classReference == null || PhpLangUtil.isParentReference((PsiElement)classReference) ? PhpUndefinedFunctionInspection.getInstruction(reference) : PhpControlFlowUtil.getAccessInstruction(classReference, PhpAccessInstruction.class);
        Reachability reachability = PhpUndefinedMethodInspection.findDfaReachability((PsiElement)classReference, reference.getName(), instruction);
        if (reachability == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(2);
        }
        return reachability;
    }

    public static Reachability findDfaReachability(@Nullable PsiElement classReference, String methodName, @Nullable PhpInstruction instruction) {
        if (!(classReference instanceof PhpExpression)) {
            return Reachability.MIGHT_BE_DEFINED;
        }
        if (methodName != null) {
            Reachability reachability = PhpUndefinedMethodInspection.performReachingDefinition(new PhpMethodExistsReachingDFAnalyzer((PhpExpression)classReference, methodName), instruction);
            if (reachability != Reachability.DEFINED && PhpUndefinedMethodInspection.findMethodsFromPhpUnitMockBuilder((PhpAccessVariableInstruction)ObjectUtils.tryCast((Object)instruction, PhpAccessVariableInstruction.class)).contains(methodName)) {
                return Reachability.DEFINED;
            }
            return reachability;
        }
        return Reachability.UNDEFINED;
    }

    public static boolean stringDefinedViaClassExists(@NotNull PhpExpression classReference, @NotNull PhpType classReferenceGlobalType) {
        PhpAccessInstruction instruction;
        if (classReference == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(3);
        }
        if (classReferenceGlobalType == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(4);
        }
        return classReferenceGlobalType.equals(PhpType.STRING) && (instruction = PhpControlFlowUtil.getAccessInstruction(classReference, PhpAccessInstruction.class)) != null && PhpUndefinedMethodInspection.performReachingDefinition(new PhpClassExistsDFAnalyzer(classReference), instruction) == Reachability.DEFINED;
    }

    public static Collection<String> findMethodsFromPhpUnitMockBuilder(@Nullable PhpAccessVariableInstruction instruction) {
        final HashSet<String> res = new HashSet<String>();
        if (instruction != null && PhpUnitAssertUtil.isInsideTestClass((PsiElement)instruction.getAnchor())) {
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    List phpUnitReferences;
                    PsiElement assignedValue = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                    if (assignedValue instanceof MethodReference && !(phpUnitReferences = StreamEx.of((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)assignedValue, StringLiteralExpression.class)).flatMap(string -> Arrays.stream(string.getReferences())).select(PhpUnitMockMethodReferenceContributor.PhpUnitMockedMethodInBuilderReference.class).map(PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase::getClassMemberName).toList()).isEmpty()) {
                        PhpType classReferenceType = PhpType.from(new PsiElement[]{((MethodReference)assignedValue).getClassReference()});
                        Project project = assignedValue.getProject();
                        if (ContainerUtil.exists(classReferenceType.getTypes(), PhpUnitMockBuilderTP::isBuilderType) || PhpUnitMockMethodReferenceContributor.isMockBuilder(project, classReferenceType.global(project))) {
                            res.addAll(phpUnitReferences);
                        }
                    }
                    return !instruction.getAccess().isWrite();
                }
            });
        }
        return res;
    }

    public static Reachability performReachingDefinition(PhpReachingDefinitionDFAnalyzer analyzer, @Nullable PhpInstruction instruction) {
        if (instruction != null) {
            Ref canBeDefined = Ref.create((Object)false);
            Ref canBeUndefined = Ref.create((Object)false);
            PhpDFAUtil.performReachingDefinition(instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, analyzer);
            if (((Boolean)canBeDefined.get()).booleanValue() && ((Boolean)canBeUndefined.get()).booleanValue()) {
                return Reachability.MIGHT_BE_DEFINED;
            }
            return (Boolean)canBeDefined.get() != false ? Reachability.DEFINED : Reachability.UNDEFINED;
        }
        return Reachability.UNDEFINED;
    }

    private static boolean isQuickFixApplicable(@NotNull PsiElement element, boolean isOnTheFly) {
        if (element == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(5);
        }
        return isOnTheFly && element.getContainingFile().isWritable();
    }

    @NotNull
    private static PhpReachingDefinitionDFAnalyzer.Result createResult(boolean result) {
        PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
        if (result) {
            dfaResult.setDefined(true);
        } else {
            dfaResult.setUndefined(true);
        }
        PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
        if (result2 == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(6);
        }
        return result2;
    }

    private static LocalQuickFix[] appendPhpUnit10RemovedAssertionFixes(MethodReference reference, LocalQuickFix[] fixes) {
        String newMethodName = PhpUnitDeprecatedCallsIn10VersionInspection.getNewMethodName(AssertType.getAssertType(reference));
        if (newMethodName != null && PhpUndefinedMethodInspection.isTestClassWithExistingMethodByName(reference.getClassReference(), newMethodName)) {
            return (LocalQuickFix[])ArrayUtil.append((Object[])fixes, (Object)((Object)new PhpUnitDeprecatedCallsIn10VersionInspection.PhpUnitReplaceWithExistingMethodQuickFix(newMethodName)));
        }
        return fixes;
    }

    private static boolean isTestClassWithExistingMethodByName(@Nullable PhpExpression classReference, String newMethodName) {
        if (classReference == null) {
            return false;
        }
        PhpIndex index = PhpIndex.getInstance(classReference.getProject());
        return classReference.getGlobalType().getTypes().stream().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).anyMatch(c -> PhpUnitUtil.extendsRootTestClass(c) && c.findMethodByName(newMethodName) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReferenceGlobalType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findDfaReachability";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDfaReachability";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stringDefinedViaClassExists";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isQuickFixApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }

    public static enum Reachability {
        DEFINED,
        UNDEFINED,
        MIGHT_BE_DEFINED;

    }

    public static class PhpMethodExistsReachingDFAnalyzer
    extends PhpEntityDefinedViaFunctionCallDFAnalyzer {
        private static final String METHOD_EXISTS = "method_exists";

        public PhpMethodExistsReachingDFAnalyzer(@NotNull PhpExpression classReference, @Nullable String methodName) {
            if (classReference == null) {
                PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(0);
            }
            super(classReference, methodName);
        }

        @Override
        @NotNull
        protected String getDefiningFunctionName() {
            return METHOD_EXISTS;
        }

        @Override
        @NotNull
        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            PhpReachingDefinitionDFAnalyzer.Result isCallableCheckResult;
            PhpReachingDefinitionDFAnalyzer.Result dfa = super.performDFA(condition, result);
            if (dfa == PhpReachingDefinitionDFAnalyzer.Result.EMPTY && (isCallableCheckResult = this.isDefinedWithIsCallable(condition, result)) != null) {
                PhpReachingDefinitionDFAnalyzer.Result result2 = isCallableCheckResult;
                if (result2 == null) {
                    PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(1);
                }
                return result2;
            }
            PhpReachingDefinitionDFAnalyzer.Result result3 = dfa;
            if (result3 == null) {
                PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(2);
            }
            return result3;
        }

        private @Nullable PhpReachingDefinitionDFAnalyzer.Result isDefinedWithIsCallable(@Nullable PsiElement condition, boolean result) {
            PhpReachingDefinitionDFAnalyzer.Result isCallableCheckResult;
            StringLiteralExpression methodNameStringLiteral;
            List arguments;
            ArrayCreationExpression arrayCallable;
            FunctionReference functionReference;
            if (condition instanceof FunctionReference && PhpLangUtil.equalsFunctionNames("is_callable", (functionReference = (FunctionReference)condition).getName()) && (arrayCallable = (ArrayCreationExpression)ObjectUtils.tryCast((Object)functionReference.getParameter(0), ArrayCreationExpression.class)) != null && (arguments = ContainerUtil.map(ArrayCreationExpressionImpl.children(arrayCallable), PhpPsiElement::getFirstPsiChild)).size() == 2 && arguments.get(0) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myClassReference, (PsiElement)((PsiElement)arguments.get(0))) && (methodNameStringLiteral = (StringLiteralExpression)ObjectUtils.tryCast(arguments.get(1), StringLiteralExpression.class)) != null && (isCallableCheckResult = this.createResult(methodNameStringLiteral.getContents(), result)) != null) {
                return isCallableCheckResult;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpMethodExistsReachingDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpMethodExistsReachingDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpClassExistsDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        private final PhpExpression myClassReference;

        public PhpClassExistsDFAnalyzer(PhpExpression classReference) {
            this.myClassReference = classReference;
        }

        @Override
        @NotNull
        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof FunctionReference) {
                PsiElement argument;
                FunctionReference functionReference = (FunctionReference)condition;
                if (!(condition instanceof MethodReference) && PhpLangUtil.equalsFunctionNames("class_exists", functionReference.getName()) && (argument = functionReference.getParameter(0)) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myClassReference, (PsiElement)argument)) {
                    PhpReachingDefinitionDFAnalyzer.Result result2 = PhpUndefinedMethodInspection.createResult(result);
                    if (result2 == null) {
                        PhpClassExistsDFAnalyzer.$$$reportNull$$$0(0);
                    }
                    return result2;
                }
            }
            PhpReachingDefinitionDFAnalyzer.Result result3 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result3 == null) {
                PhpClassExistsDFAnalyzer.$$$reportNull$$$0(1);
            }
            return result3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpClassExistsDFAnalyzer", "performDFA"));
        }
    }

    public static abstract class PhpEntityDefinedViaFunctionCallDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        protected final PhpExpression myClassReference;
        protected final String myEntityName;

        public PhpEntityDefinedViaFunctionCallDFAnalyzer(@NotNull PhpExpression classReference, @Nullable String entityName) {
            if (classReference == null) {
                PhpEntityDefinedViaFunctionCallDFAnalyzer.$$$reportNull$$$0(0);
            }
            this.myClassReference = classReference;
            this.myEntityName = entityName;
        }

        @Override
        @NotNull
        public PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            if (condition instanceof FunctionReference) {
                PsiElement method;
                String methodName;
                PhpReachingDefinitionDFAnalyzer.Result dfaResult;
                PsiElement[] parameters;
                FunctionReference functionReference = (FunctionReference)condition;
                if (!(condition instanceof MethodReference) && PhpLangUtil.equalsFunctionNames(this.getDefiningFunctionName(), functionReference.getName()) && (parameters = functionReference.getParameters()).length > 1 && this.classReferenceIsReferencedInCondition(parameters[0]) && (dfaResult = this.createResult(methodName = PhpCodeInsightUtil.toString(method = parameters[1], false), result)) != null) {
                    PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                    if (result2 == null) {
                        PhpEntityDefinedViaFunctionCallDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
            }
            PhpReachingDefinitionDFAnalyzer.Result result3 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result3 == null) {
                PhpEntityDefinedViaFunctionCallDFAnalyzer.$$$reportNull$$$0(2);
            }
            return result3;
        }

        private boolean classReferenceIsReferencedInCondition(PsiElement classReferenceInCondition) {
            Project project = classReferenceInCondition.getProject();
            if (classReferenceInCondition instanceof StringLiteralExpression) {
                String fqn = PhpTypeConditionDFAnalyzer.getClassFqnFromContent((StringLiteralExpression)classReferenceInCondition);
                return this.myClassReference.getGlobalType().getTypes().contains(fqn);
            }
            if (classReferenceInCondition instanceof ClassConstantReference && PhpLangUtil.equalsClassConstantNames(((ClassConstantReference)classReferenceInCondition).getName(), "class")) {
                PhpExpression classReference = ((ClassConstantReference)classReferenceInCondition).getClassReference();
                return classReference != null && PhpType.intersectsGlobal(project, this.myClassReference.getType(), classReference.getType());
            }
            if (PhpLangUtil.isParentReference((PsiElement)this.myClassReference) && classReferenceInCondition instanceof FunctionReference && PhpLangUtil.isThisReference(((FunctionReference)classReferenceInCondition).getParameter(0)) && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)classReferenceInCondition, "get_parent_class")) {
                return true;
            }
            return PhpLangUtil.equalsVariableNames(this.myClassReference.getText(), classReferenceInCondition.getText());
        }

        @NotNull
        protected abstract String getDefiningFunctionName();

        protected PhpReachingDefinitionDFAnalyzer.Result createResult(String methodNameInsideMethodExists, boolean result) {
            if (this.myEntityName != null && !PhpLangUtil.equalsMethodNames(methodNameInsideMethodExists, this.myEntityName)) {
                return null;
            }
            return PhpUndefinedMethodInspection.createResult(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpEntityDefinedViaFunctionCallDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpEntityDefinedViaFunctionCallDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

