/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpFqnInspectionBase;
import com.jetbrains.php.lang.inspections.PhpFullyQualifiedNameUsageInspection;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnnecessaryFullyQualifiedNameInspection
extends PhpFqnInspectionBase
implements CleanupLocalInspectionTool {
    private static final PhpRemoveRedundantQualifierQuickFix FIX_ON_NAMESPACE = new PhpRemoveRedundantQualifierQuickFix(PhpUnnecessaryFullyQualifiedNameInspection.getFixName());
    private static final PhpRemoveRedundantQualifierQuickFix FIX_ON_CLASSNAME = new PhpRemoveRedundantQualifierQuickFix(PhpBundle.message("quickfix.remove.unnecessary.qualifier.on.class.name", new Object[0]));
    private static final Key<PhpUnnecessaryFullyQualifiedNameInspection> SHORT_NAME_KEY = Key.create((String)"PhpUnnecessaryFullyQualifiedNameInspection");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClassReference(ClassReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.CLASS);
            }

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.FUNCTION);
            }

            @Override
            public void visitPhpConstantReference(ConstantReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.CONSTANT);
            }

            @Override
            public void visitPhpDocType(PhpDocType type) {
                this.checkDocReference(type);
            }

            @Override
            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpDocRef) {
                    this.checkDocReference((PhpDocRef)element);
                }
            }

            private void checkDocReference(PhpReferenceBase type) {
                PhpReferenceBase reference;
                String simplifiedFqn;
                PhpDocTag aTag;
                if (!PhpCodeInsightUtil.hasQualifier(type)) {
                    return;
                }
                if ((type instanceof PhpDocRef || type instanceof PhpDocType) && PhpUnitUtil.isPhpUnitTag(aTag = PhpPsiUtil.getParentOfClass((PsiElement)type, PhpDocTag.class))) {
                    return;
                }
                if (!PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(type) && (simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.this.createSimplifiedFQN(reference = PhpPsiUtil.getClassBaseReferenceAt((PsiElement)type), PhpGroupUseElement.PhpUseKeyword.CLASS)) != null) {
                    this.registerWarning(reference, simplifiedFqn, isOnTheFly);
                }
            }

            public void check(@Nullable PhpReference reference, PhpGroupUseElement.PhpUseKeyword keyword) {
                String simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.this.createSimplifiedFQN(reference, keyword);
                if (simplifiedFqn != null) {
                    this.registerWarning(reference, simplifiedFqn, isOnTheFly);
                }
            }

            private void registerWarning(@NotNull PhpReferenceBase reference, String simplifiedFqn, boolean isOnTheFly2) {
                Object namespaceReference;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, PhpNamespaceReference.INSTANCEOF)) != null) {
                    TextRange unnecessaryQualifierRange;
                    String parentNamespace = PhpLangUtil.getParentNamespaceFQN(PhpLangUtil.toFQN(simplifiedFqn));
                    TextRange textRange = unnecessaryQualifierRange = PhpFullyQualifiedNameUsageInspection.isShortName(simplifiedFqn) ? null : TextRange.create((int)0, (int)(namespaceReference.getTextLength() - parentNamespace.length() + 1));
                    if (unnecessaryQualifierRange == null || !unnecessaryQualifierRange.isEmpty()) {
                        ProblemHighlightType type = PhpFullyQualifiedNameUsageInspection.getHighlightType(reference);
                        if (type == ProblemHighlightType.INFORMATION && !isOnTheFly2) {
                            return;
                        }
                        holder.registerProblem(namespaceReference, PhpBundle.message("inspection.unnecessary.qualifier.already.imported.message", new Object[0]), type, unnecessaryQualifierRange, PhpUnnecessaryFullyQualifiedNameInspection.this.getQuickFixes(reference, (LocalQuickFix)FIX_ON_NAMESPACE));
                        ASTNode nameNode = reference.getNameNode();
                        if (nameNode != null && isOnTheFly2) {
                            TextRange range = new TextRange(1, nameNode.getTextLength());
                            holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.unnecessary.qualifier.already.imported.message", new Object[0]), ProblemHighlightType.INFORMATION, range, PhpUnnecessaryFullyQualifiedNameInspection.this.getQuickFixes(reference, (LocalQuickFix)FIX_ON_CLASSNAME));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$1", "registerWarning"));
            }
        };
    }

    @Override
    @NotNull
    protected Key<? extends PhpFqnInspectionBase> getShortNameKey() {
        Key<PhpUnnecessaryFullyQualifiedNameInspection> key = SHORT_NAME_KEY;
        if (key == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(1);
        }
        return key;
    }

    public static boolean phpdocUseFqcn(@NotNull PhpReferenceBase type) {
        if (type == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(2);
        }
        return ((PhpCodeStyleSettings)CodeStyle.getSettings((Project)type.getProject()).getCustomSettings(PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN;
    }

    @Nullable
    private String createSimplifiedFQN(@Nullable PhpReferenceBase reference, PhpGroupUseElement.PhpUseKeyword keyword) {
        if (reference == null || !PhpImportClassIntention.canBeImported(reference)) {
            return null;
        }
        String fqn = reference.getFQN();
        if (fqn == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)PhpLangUtil.toShortName(fqn))) {
            return null;
        }
        if (PhpUnnecessaryFullyQualifiedNameInspection.isGlobalNamespaceFqn(fqn) && this.IGNORE_GLOBAL_NAMESPACE) {
            return null;
        }
        if (PhpUnnecessaryFullyQualifiedNameInspection.inCoversDefaultClassTag(reference)) {
            return null;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
        if (!(scope instanceof PhpNamespace || this.ENABLE_IN_FILE_SCOPE && scope instanceof PhpFile)) {
            return null;
        }
        String simplifiedFqn = PhpUnnecessaryFullyQualifiedNameInspection.createSimplifiedFqn(reference, scope);
        if (simplifiedFqn == null || PhpLangUtil.isFqn(simplifiedFqn)) {
            return null;
        }
        Map<String, String> usedAliases = PhpUnnecessaryFullyQualifiedNameInspection.collectAliasesExceptFqn(scope, fqn, keyword);
        if (PhpUnnecessaryFullyQualifiedNameInspection.hasPartialNameConflicts(simplifiedFqn, usedAliases, fqn)) {
            return null;
        }
        if (PhpFullyQualifiedNameUsageInspection.isShortName(simplifiedFqn) != usedAliases.containsKey(StringUtil.toLowerCase((String)PhpLangUtil.toShortName(simplifiedFqn)))) {
            if (keyword == PhpGroupUseElement.PhpUseKeyword.CLASS && (StringUtil.isEmpty((String)simplifiedFqn) || PhpReferenceInsertHandler.SPECIAL_REFERENCES.contains(simplifiedFqn))) {
                return null;
            }
            return simplifiedFqn;
        }
        return null;
    }

    private static boolean hasPartialNameConflicts(String simplifiedFqn, Map<String, String> usedAliases, String originalFQN) {
        String partialNamespaceStart;
        int index = simplifiedFqn.indexOf(92);
        if (index >= 0 && (partialNamespaceStart = usedAliases.get(StringUtil.toLowerCase((String)simplifiedFqn.substring(0, index)))) != null) {
            String importedFQN = partialNamespaceStart + simplifiedFqn.substring(index);
            return !PhpLangUtil.equalsClassNames(importedFQN, originalFQN);
        }
        return false;
    }

    public static boolean inCoversDefaultClassTag(@NotNull PhpReferenceBase reference) {
        PhpDocTag docTag;
        if (reference == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(3);
        }
        return (docTag = PhpPsiUtil.getParentOfClass((PsiElement)reference, PhpDocTag.class)) != null && (StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass") || StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@covers"));
    }

    @Nullable
    public static String createSimplifiedFqn(@NotNull PhpReferenceBase reference, PhpPsiElement scopeForUseOperator) {
        String immediateFQN;
        if (reference == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(4);
        }
        return (immediateFQN = PhpCodeInsightUtil.getImmediateFQN(reference)) != null && PhpLangUtil.isFqn(immediateFQN) ? PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, immediateFQN) : null;
    }

    @NotNull
    public static Map<String, String> collectAliasesExceptFqn(PhpPsiElement scopeForUseOperator, String fqn, PhpGroupUseElement.PhpUseKeyword keyword) {
        Map map = EntryStream.of(PhpCodeInsightUtil.getAliasesInScope(scopeForUseOperator, keyword)).filterValues(aliasFQN -> !aliasFQN.equals(fqn)).mapKeys(StringUtil::toLowerCase).toMap();
        if (map == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ENABLE_IN_FILE_SCOPE", (String)PhpBundle.message("inspection.fully.qualified.name.usage.option.enable.file.scope", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_GLOBAL_NAMESPACE", (String)PhpBundle.message("inspection.fully.qualified.name.usage.name.option.ignore.global.namespace", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUnnecessaryFullyQualifiedNameInspection.$$$reportNull$$$0(6);
        }
        return optPane;
    }

    @Nls
    public static String getFixName() {
        return PhpBundle.message("quickfix.remove.unnecessary.qualifier", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAliasesExceptFqn";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "phpdocUseFqcn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inCoversDefaultClassTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSimplifiedFqn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static final class PhpRemoveRedundantQualifierQuickFix
    extends PsiUpdateModCommandQuickFix {
        @Nls
        private final String myName;

        private PhpRemoveRedundantQualifierQuickFix(@Nls String name) {
            this.myName = name;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpReferenceBase reference;
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(3);
            }
            if ((reference = PhpPsiUtil.getClassBaseReferenceAt(element)) == null) {
                return;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(reference);
            if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                return;
            }
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
            if (scopeForUseOperator == null) {
                return;
            }
            if (reference instanceof ConstantReference) {
                PhpRemoveRedundantQualifierQuickFix.replaceConstantReference(project, scopeForUseOperator, fqn);
            } else if (reference instanceof FunctionReference) {
                this.replaceFunctionReference(project, scopeForUseOperator, fqn);
            } else {
                PhpRemoveRedundantQualifierQuickFix.replaceClassReference(scopeForUseOperator, fqn);
            }
        }

        private static void replaceConstantReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(4);
            }
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(5);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(6);
            }
            final HashSet<ConstantReference> references = new HashSet<ConstantReference>();
            scopeForUseOperator.acceptChildren(new PhpReferenceInScopeCollector(){

                @Override
                public void visitPhpConstantReference(ConstantReference reference) {
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(reference))) {
                        references.add(reference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            ConstantReference newConstantReference = PhpPsiElementFactory.createConstantReference(project, qualifiedName);
            PhpRemoveRedundantQualifierQuickFix.doReplaceReferences(references, newConstantReference);
        }

        private static void doReplaceReferences(Set<ConstantReference> references, ConstantReference newConstantReference) {
            for (PhpReference phpReference : references) {
                phpReference.replace((PsiElement)newConstantReference);
            }
        }

        private void replaceFunctionReference(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (project == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(7);
            }
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(8);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(9);
            }
            final HashSet<FunctionReference> references = new HashSet<FunctionReference>();
            scopeForUseOperator.acceptChildren(new PhpReferenceInScopeCollector(){

                @Override
                public void visitPhpFunctionCall(FunctionReference reference) {
                    super.visitPhpFunctionCall(reference);
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(reference))) {
                        references.add(reference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, qualifiedName + "()");
            PhpNamespaceReference newNamespaceReference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)functionReference, PhpNamespaceReference.INSTANCEOF);
            PsiElement newIdentifier = PhpPsiUtil.getChildOfType((PsiElement)functionReference, PhpTokenTypes.IDENTIFIER);
            assert (newIdentifier != null) : "Failed to find identifier in '" + functionReference.getText() + "'";
            PhpRemoveRedundantQualifierQuickFix.doReplaceFunctionReferences(references, newNamespaceReference, newIdentifier);
        }

        private static void doReplaceFunctionReferences(Set<FunctionReference> references, PhpNamespaceReference newNamespaceReference, PsiElement newIdentifier) {
            for (FunctionReference reference : references) {
                PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                Object namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, PhpNamespaceReference.INSTANCEOF);
                if (namespaceReference != null) {
                    if (newNamespaceReference == null) {
                        namespaceReference.getParent().deleteChildRange(namespaceReference, namespaceReference);
                    } else {
                        namespaceReference.replace((PsiElement)newNamespaceReference);
                    }
                }
                assert (identifier != null) : "Failed to find identifier in '" + reference.getText() + "'";
                identifier.replace(newIdentifier);
            }
        }

        private static void replaceClassReference(@NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn) {
            if (scopeForUseOperator == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(10);
            }
            if (originalFqn == null) {
                PhpRemoveRedundantQualifierQuickFix.$$$reportNull$$$0(11);
            }
            final HashSet references = new HashSet();
            scopeForUseOperator.acceptChildren(new PhpReferenceInScopeCollector(){

                @Override
                public void visitPhpDocType(PhpDocType phpDocType) {
                    super.visitPhpDocType(phpDocType);
                    this.processDocReference(phpDocType);
                }

                private void processDocReference(PhpReferenceBase phpDocType) {
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(phpDocType)) && !PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(phpDocType)) {
                        references.add(phpDocType);
                    }
                }

                @Override
                public void visitPhpElement(PhpPsiElement element) {
                    super.visitPhpElement(element);
                    if (element instanceof PhpDocRef) {
                        this.processDocReference((PhpDocRef)element);
                    }
                }

                @Override
                public void visitPhpClassReference(ClassReference classReference) {
                    if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(classReference))) {
                        references.add(classReference);
                    }
                }
            });
            String qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, originalFqn);
            for (PhpReferenceBase reference : references) {
                PhpImportClassIntention.replaceClassReference(reference, qualifiedName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$PhpRemoveRedundantQualifierQuickFix";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeForUseOperator";
                    break;
                }
                case 6: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnnecessaryFullyQualifiedNameInspection$PhpRemoveRedundantQualifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceConstantReference";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceFunctionReference";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceClassReference";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }

        private static class PhpReferenceInScopeCollector
        extends PhpRecursiveElementVisitor {
            private PhpReferenceInScopeCollector() {
            }

            @Override
            public void visitPhpElement(PhpPsiElement element) {
                if (!(PhpCodeInsightUtil.isScopeForUseOperator(element) || element instanceof PhpUse && !((PhpUse)element).isTraitImport())) {
                    super.visitPhpElement(element);
                }
            }
        }
    }
}

