/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpUnusedAliasInspection
extends PhpInspection {
    private static final Set<Class<? extends PsiElement>> REF_CLASSES = Set.of(FunctionReference.class, ConstantReference.class, ClassReference.class, PhpNamespaceReference.class, ContributedReferenceHost.class);
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpRemoveStatementQuickFix.REMOVE_USE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedAliasInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFile(PhpFile phpFile) {
                Collection definitions = phpFile.getTopLevelDefs().values();
                List phpUses = ((StreamEx)StreamEx.of((Collection)definitions).select(PhpUse.class).filter(u -> u.getTargetReference() != null)).toList();
                Collection<PhpUse> unusedUses = PhpUnusedAliasInspection.filterUnused(phpUses);
                for (PhpUse use : phpUses) {
                    if (unusedUses.contains(use)) {
                        holder.registerProblem((PsiElement)use, PhpBundle.message("inspection.php.unused.alias.description2", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, FIXES);
                        continue;
                    }
                    if (!PhpCodeInsightUtil.isUnnecessary(use)) continue;
                    holder.registerProblem((PsiElement)use, PhpBundle.message("inspection.php.unused.alias.description", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, FIXES);
                }
                super.visitPhpFile(phpFile);
            }
        };
    }

    private static Collection<PhpUse> filterUnused(@NotNull Collection<PhpUse> phpUses) {
        if (phpUses == null) {
            PhpUnusedAliasInspection.$$$reportNull$$$0(1);
        }
        return StreamEx.of(phpUses).groupingBy(u -> PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)u)).entrySet().stream().flatMap(entry -> PhpUnusedAliasInspection.filterUnused((PsiElement)entry.getKey(), (Collection)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    public static Set<PhpUse> filterUnused(@NotNull PsiElement scope, @NotNull Collection<PhpUse> allUses) {
        if (scope == null) {
            PhpUnusedAliasInspection.$$$reportNull$$$0(2);
        }
        if (allUses == null) {
            PhpUnusedAliasInspection.$$$reportNull$$$0(3);
        }
        MultiMap usesByName = new MultiMap();
        List resolvedUses = ContainerUtil.filter(allUses, u -> u.getTargetReference() != null && u.getTargetReference().multiResolve(true).length != 0);
        for (PhpUse use : resolvedUses) {
            String name = use.getAliasName() != null ? use.getAliasName() : use.getName();
            usesByName.putValue((Object)StringUtil.toLowerCase((String)name), (Object)use);
        }
        HashSet<PhpUse> unusedUses = new HashSet<PhpUse>(resolvedUses);
        PsiReferenceService referenceService = PsiReferenceService.getService();
        SyntaxTraverser.psiTraverser((PsiElement)scope).traverse().filter(e -> ContainerUtil.exists(REF_CLASSES, r -> r.isInstance(e)) || PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_IDENTIFIER)).flatMap(e -> Arrays.asList(e instanceof ContributedReferenceHost || PhpPsiUtil.isOfType(e, PhpDocTokenTypes.DOC_IDENTIFIER) ? referenceService.getContributedReferences(e) : e.getReferences())).forEach(reference -> {
            if (unusedUses.isEmpty()) {
                return;
            }
            String name = PhpTargetElementEvaluator.getName(reference);
            Collection uses = usesByName.get((Object)StringUtil.toLowerCase((String)name));
            for (PhpUse use : uses) {
                if (!unusedUses.contains(use) || !PhpUnusedAliasInspection.isReferenceToUse(reference, use)) continue;
                unusedUses.remove(use);
            }
        });
        return unusedUses;
    }

    private static boolean isReferenceToUse(PsiReference reference, PhpUse use) {
        String aliasedName;
        String string = aliasedName = use.getAliasName() != null ? use.getAliasName() : use.getName();
        return PhpTargetElementEvaluator.isReferenceToUse(reference, reference.getElement(), use) && PhpCodeInsightUtil.isReferenceToAlias(reference, aliasedName, !PhpUseImpl.isOfConst(use));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpUses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUses";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedAliasInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "filterUnused";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

