/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRemoveMethodWithPropagationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class PhpUnusedPrivateMethodInspection
extends PhpInspection {
    private static final int MAX_TRAIT_INVESTIGATION_DEPTH = 20;
    public static final PhpRemoveStatementQuickFix BATCH_FIX = new PhpRemoveStatementQuickFix("method", Method.INSTANCEOF);
    private static final LocalQuickFix FIX_WITH_PROPAGATION = new PhpRemoveMethodWithPropagationQuickFix();
    public boolean SKIP_CONSTRUCT_METHOD = true;
    public boolean SKIP_CLONE_METHOD = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethod(Method method) {
                if (method instanceof PhpPropertyHook) {
                    return;
                }
                PsiElement namePsiElement = method.getNameIdentifier();
                if (namePsiElement == null || namePsiElement.getTextLength() == 0) {
                    return;
                }
                if (method.getAccess().isPrivate()) {
                    CharSequence name = method.getNameCS();
                    PhpClass clazz = method.getContainingClass();
                    if (clazz == null) {
                        return;
                    }
                    Method.MethodType methodType = method.getMethodType(false);
                    if (methodType == Method.MethodType.CONSTRUCTOR) {
                        if (!PhpUnusedPrivateMethodInspection.this.SKIP_CONSTRUCT_METHOD && !PhpUnusedPrivateMethodInspection.isObjectCreationExist(clazz)) {
                            this.registerProblem(namePsiElement);
                        }
                    } else if (PhpLangUtil.equalsMethodNames("__clone", name)) {
                        if (!PhpUnusedPrivateMethodInspection.this.SKIP_CLONE_METHOD && !PhpUnusedPrivateMethodInspection.isObjectCloneExist(clazz)) {
                            this.registerProblem(namePsiElement);
                        }
                    } else if (!PhpUnusedPrivateMethodInspection.hasRefs(method, method, clazz)) {
                        this.registerProblem(namePsiElement);
                    }
                }
            }

            private void registerProblem(@NotNull PsiElement namePsiElement) {
                if (namePsiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                holder.registerProblem(namePsiElement, PhpUnusedPrivateMethodInspection.getDescriptionTemplate(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{isOnTheFly ? FIX_WITH_PROPAGATION : BATCH_FIX});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePsiElement", "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection$1", "registerProblem"));
            }
        };
    }

    @NotNull
    public static SearchScope constructSearchScope(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(1);
        }
        if (clazz.isTrait()) {
            HashSet allUsages = ContainerUtil.newHashSet((Object[])new PhpClass[]{clazz});
            PhpUnusedPrivateMethodInspection.processTraitUsage(clazz, allUsages, 0);
            return new LocalSearchScope(allUsages.toArray(PsiElement.EMPTY_ARRAY));
        }
        SearchScope searchScope = new LocalSearchScope((PsiElement)clazz).union(new LocalSearchScope((PsiElement[])clazz.getTraits()));
        if (searchScope == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    private static void processTraitUsage(@NotNull PhpClass clazz, @NotNull Collection<PhpClass> allUsages, int depth) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(3);
        }
        if (allUsages == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(4);
        }
        Collection<PhpClass> classes = PhpIndex.getInstance(clazz.getProject()).getTraitUsages(clazz);
        for (PhpClass aClass : classes) {
            if (allUsages.contains(aClass)) continue;
            allUsages.add(aClass);
            if (depth >= 20 || !aClass.isTrait()) continue;
            PhpUnusedPrivateMethodInspection.processTraitUsage(aClass, allUsages, depth + 1);
        }
    }

    public static boolean hasRefs(@NotNull PhpClassMember usageMethod, @NotNull Method methodToFindReferencesOutside, @NotNull PhpClass usageClass) {
        if (usageMethod == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(5);
        }
        if (methodToFindReferencesOutside == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(6);
        }
        if (usageClass == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(7);
        }
        SearchScope searchScope = PhpUnusedPrivateMethodInspection.constructSearchScope(usageClass);
        return PhpPsiUtil.hasReferencesInSearchScope(searchScope, (PsiElement)usageMethod, PhpUnusedPrivateMethodInspection.getReferencesOutsideMethodProcessor(methodToFindReferencesOutside));
    }

    @NotNull
    public static CommonProcessors.FindProcessor<PsiReference> getReferencesOutsideMethodProcessor(final @NotNull Method method) {
        if (method == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(8);
        }
        return new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                if (reference instanceof PhpReference) {
                    Method outerMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)((PhpReference)reference), Method.INSTANCEOF, PhpClass.INSTANCEOF);
                    return outerMethod == null || !PhpLangUtil.equalsMethodNames(outerMethod.getNameCS(), method.getName());
                }
                return true;
            }
        };
    }

    private static boolean isObjectCreationExist(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(9);
        }
        final String fqn = clazz.getFQN();
        PhpInspection.PhpReferenceSearchVisitor visitor = new PhpInspection.PhpReferenceSearchVisitor(){

            @Override
            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference reference = expression.getClassReference();
                if (reference != null && PhpLangUtil.equalsClassNames(fqn, reference.getFQN())) {
                    this.foundRef.set((Object)true);
                }
                super.visitPhpNewExpression(expression);
            }
        };
        clazz.accept(visitor);
        return visitor.isReferenceFound();
    }

    private static boolean isObjectCloneExist(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(10);
        }
        final String fqn = clazz.getFQN();
        PhpInspection.PhpReferenceSearchVisitor visitor = new PhpInspection.PhpReferenceSearchVisitor(){

            @Override
            public void visitPhpUnaryExpression(UnaryExpression expr) {
                PhpPsiElement value;
                ASTNode node = expr.getNode();
                if (node != null && node.getElementType() == PhpElementTypes.CLONE_EXPRESSION && (value = expr.getValue()) instanceof PhpTypedElement) {
                    PhpType phpType = ((PhpTypedElement)value).getType();
                    for (String type : phpType.getTypes()) {
                        if (!PhpLangUtil.equalsClassNames(PhpTypeSignatureKey.POLYMORPHIC_CLASS.unsign(type), fqn)) continue;
                        this.foundRef.set((Object)true);
                    }
                }
                super.visitPhpUnaryExpression(expr);
            }
        };
        clazz.accept(visitor);
        return visitor.isReferenceFound();
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"SKIP_CONSTRUCT_METHOD", (String)PhpBundle.message("inspection.unused.private.method.option.ignore.constructor", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"SKIP_CLONE_METHOD", (String)PhpBundle.message("inspection.unused.private.method.option.ignore.clone", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(11);
        }
        return optPane;
    }

    @InspectionMessage
    private static String getDescriptionTemplate() {
        return PhpBundle.message("inspection.unused.private.method.problem.batch", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUsages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToFindReferencesOutside";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "constructSearchScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructSearchScope";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processTraitUsage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasRefs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesOutsideMethodProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isObjectCreationExist";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isObjectCloneExist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11 -> new IllegalStateException(string);
        };
    }
}

