/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.TriConsumer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUselessTrailingCommaInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(0);
        }
        TriConsumer consumer = (trailingComma, nextSibling, isMultiline) -> PhpUselessTrailingCommaInspection.registerTrailingCommaProblem(holder, trailingComma, nextSibling, isMultiline);
        return new Visitor((TriConsumer<? super PsiElement, ? super PsiElement, ? super Boolean>)consumer, false, false, false);
    }

    private static void registerTrailingCommaProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement trailingComma, @Nullable PsiElement nextSibling, boolean isMultiline) {
        if (holder == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(1);
        }
        if (trailingComma == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(2);
        }
        if (nextSibling instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)nextSibling.getText())) {
            return;
        }
        if (isMultiline) {
            holder.registerProblem(trailingComma, PhpBundle.message("inspection.php.useless.trailing.comma.inspection.desc", new Object[0]), new LocalQuickFix[]{AddLineBreakAfterTrailingCommaQuickFix.INSTANCE});
        } else {
            holder.registerProblem(trailingComma, PhpBundle.message("inspection.php.useless.trailing.comma.inspection.desc", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{RemoveTrailingCommaQuickFix.INSTANCE});
        }
    }

    @Nullable
    public static PsiElement getWhiteSpace(@NotNull PsiElement element) {
        Object paren;
        if (element == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(3);
        }
        if ((paren = PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> !(e instanceof PsiComment) && !(e instanceof PsiWhiteSpace)))) == null) {
            return null;
        }
        return paren.getPrevSibling();
    }

    private static boolean isSupportTrailingComma(@NotNull ParameterList list) {
        if (list == null) {
            PhpUselessTrailingCommaInspection.$$$reportNull$$$0(4);
        }
        PsiElement parent = list.getParent();
        Project project = list.getProject();
        if (parent instanceof Function && PhpLanguageFeature.TRAILING_COMMA_IN_PARAMETER_LIST.isSupported(project)) {
            return true;
        }
        return parent instanceof FunctionReference && PhpLanguageFeature.TRAILING_COMMA_IN_FUNCTION_CALL.isSupported(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trailingComma";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTrailingCommaProblem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getWhiteSpace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportTrailingComma";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PhpElementVisitor {
        private final TriConsumer<? super PsiElement, ? super PsiElement, ? super Boolean> problemConsumer;
        private final Boolean isTrailingCommaAllowedInOneLineParameterList;
        private final Boolean isTrailingCommaAllowedInOneLineFunctionCall;
        private final Boolean isTrailingCommaAllowedInOneLineUseList;

        public Visitor(TriConsumer<? super PsiElement, ? super PsiElement, ? super Boolean> problemConsumer, Boolean isTrailingCommaAllowedInOneLineParameterList, Boolean isTrailingCommaAllowedInOneLineFunctionCall, Boolean isTrailingCommaAllowedInOneLineUseList) {
            this.problemConsumer = problemConsumer;
            this.isTrailingCommaAllowedInOneLineParameterList = isTrailingCommaAllowedInOneLineParameterList;
            this.isTrailingCommaAllowedInOneLineFunctionCall = isTrailingCommaAllowedInOneLineFunctionCall;
            this.isTrailingCommaAllowedInOneLineUseList = isTrailingCommaAllowedInOneLineUseList;
        }

        @Override
        public void visitPhpParameterList(ParameterList list) {
            boolean isTrailingCommaAllowedInOneLine = list.getParent() instanceof Function ? this.isTrailingCommaAllowedInOneLineParameterList : this.isTrailingCommaAllowedInOneLineFunctionCall;
            boolean hasTrailingComma = ((ParameterListImpl)list).hasTrailingComma();
            if (!hasTrailingComma || !PhpUselessTrailingCommaInspection.isSupportTrailingComma(list)) {
                return;
            }
            PsiElement trailingComma = list.getLastChild();
            PsiElement nextSibling = PhpUselessTrailingCommaInspection.getWhiteSpace((PsiElement)list);
            boolean isMultilineParameterList = StringUtil.containsLineBreak((CharSequence)list.getText());
            if (!isMultilineParameterList && isTrailingCommaAllowedInOneLine) {
                return;
            }
            this.problemConsumer.accept((Object)trailingComma, (Object)nextSibling, (Object)isMultilineParameterList);
            super.visitPhpParameterList(list);
        }

        @Override
        public void visitPhpFunction(Function function) {
            super.visitPhpFunction(function);
            if (!function.isClosure() || !PhpLanguageFeature.TRAILING_COMMA_IN_CLOSURE_USE_LIST.isSupported(function.getProject())) {
                return;
            }
            PhpUseList useList = (PhpUseList)PsiTreeUtil.getChildOfType((PsiElement)function, PhpUseList.class);
            if (useList == null) {
                return;
            }
            PsiElement trailingComma = PhpUseListImpl.getTrailingComma(useList);
            if (trailingComma == null) {
                return;
            }
            boolean isMultilineUseList = Visitor.isMultilineUseList(useList, trailingComma);
            if (!isMultilineUseList && this.isTrailingCommaAllowedInOneLineUseList.booleanValue()) {
                return;
            }
            PsiElement nextSibling = PhpUselessTrailingCommaInspection.getWhiteSpace(trailingComma);
            this.problemConsumer.accept((Object)trailingComma, (Object)nextSibling, (Object)isMultilineUseList);
        }

        private static boolean isMultilineUseList(@NotNull PhpUseList useList, @NotNull PsiElement trailingComma) {
            PsiElement brackets;
            if (useList == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (trailingComma == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((brackets = PhpPsiUtil.getChildOfType((PsiElement)useList, PhpTokenTypes.chLPAREN)) == null) {
                return false;
            }
            Ref result = new Ref((Object)false);
            PsiTreeUtil.processElements((PsiElement)useList, e -> {
                PsiElement whiteSpace;
                if (e.getTextOffset() > brackets.getTextOffset() && e.getTextOffset() < trailingComma.getTextOffset() && StringUtil.containsLineBreak((CharSequence)e.getText())) {
                    result.set((Object)true);
                    return false;
                }
                if (e.getTextOffset() > trailingComma.getTextOffset() && PhpPsiUtil.isOfType(e, PhpTokenTypes.COMMENTS) && (whiteSpace = e.getNextSibling()) instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)whiteSpace.getText())) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            });
            return (Boolean)result.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "useList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "trailingComma";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$Visitor";
            objectArray[2] = "isMultilineUseList";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddLineBreakAfterTrailingCommaQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final AddLineBreakAfterTrailingCommaQuickFix INSTANCE = new AddLineBreakAfterTrailingCommaQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.add.line.break.after.trailing.comma", new Object[0]);
            if (string == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddLineBreakAfterTrailingCommaQuickFix.$$$reportNull$$$0(3);
            }
            if (element.getParent() == null) {
                return;
            }
            element.getParent().addAfter((PsiElement)PhpPsiElementFactory.createNewLine(element.getProject()), element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$AddLineBreakAfterTrailingCommaQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$AddLineBreakAfterTrailingCommaQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RemoveTrailingCommaQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final RemoveTrailingCommaQuickFix INSTANCE = new RemoveTrailingCommaQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.remove.useless.trailing.comma", new Object[0]);
            if (string == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveTrailingCommaQuickFix.$$$reportNull$$$0(3);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$RemoveTrailingCommaQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUselessTrailingCommaInspection$RemoveTrailingCommaQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

