/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddAttributeQuickFixBase
extends PsiUpdateModCommandQuickFix {
    private final String myAttributeText;

    public PhpAddAttributeQuickFixBase(String attributeText) {
        this.myAttributeText = attributeText;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.add.attribute", PhpLangUtil.toShortName(this.myAttributeText));
        if (string == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(3);
        }
        Function function = PhpPsiUtil.getParentOfClass(element, false, Function.class);
        PhpAddAttributeQuickFixBase.addAttribute(function, this.myAttributeText);
    }

    public static void addAttribute(@Nullable PhpAttributesOwner attributeOwner, @NotNull String attributeText) {
        if (attributeText == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(4);
        }
        if (attributeOwner == null) {
            return;
        }
        PhpAttributesList attributesList = PhpPsiElementFactory.createAttributesList(attributeOwner.getProject(), attributeText);
        PhpAttributesList addedAttribute = (PhpAttributesList)attributeOwner.addBefore((PsiElement)attributesList, attributeOwner.getFirstChild());
        PhpAddAttributeQuickFixBase.importClassReference(attributeOwner.getProject(), addedAttribute);
    }

    private static void importClassReference(@NotNull Project project, PhpAttributesList attribute) {
        if (project == null) {
            PhpAddAttributeQuickFixBase.$$$reportNull$$$0(5);
        }
        ClassReference attributeReference = ((PhpAttribute)ContainerUtil.getFirstItem((Collection)attribute.getAttributes())).getClassReference();
        assert (attributeReference != null);
        String qualifiedName = PhpMoveMemberProcessor.importClassAndGetName(attributeReference, Collections.emptyList(), PhpLangUtil.toFQN(attributeReference.getText()));
        attributeReference.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, qualifiedName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpAddAttributeQuickFixBase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpAddAttributeQuickFixBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importClassReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

