/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAttributeCanBeAddedToOverriddenMemberInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpDocArrayShapeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpArrayShapeRegistry;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpAttributesRegistryBase;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayShapeCanBeAddedInspection
extends PhpInspection {
    private static final int SHAPE_LIMIT = 10;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayShapeCanBeAddedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethod(Method method) {
                this.visitPhpFunction(method);
            }

            @Override
            public void visitPhpFunction(Function function) {
                if (function instanceof PhpDocMethod) {
                    return;
                }
                boolean containsArrayShapesAttribute = !function.getAttributes("\\JetBrains\\PhpStorm\\ArrayShape").isEmpty();
                boolean containsDocArrayShapes = PhpArrayShapeCanBeAddedInspection.containsDocArrayShapes(function);
                if ((!PhpLanguageLevel.current((Project)function.getProject()).isAtLeast(PhpLanguageLevel.PHP800) || containsArrayShapesAttribute) && containsDocArrayShapes) {
                    return;
                }
                PsiElement nameIdentifier = function.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes = PhpArrayShapeCanBeAddedInspection.getShapes(function);
                if (shapes != null && shapes.size() < 10 && ContainerUtil.exists(shapes, s -> !(s.getKey() instanceof PhpExpectedFunctionScalarArgument) || ((PhpExpectedFunctionScalarArgument)s.getKey()).isStringLiteral())) {
                    boolean canBeHighlighted;
                    ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
                    if (PhpLanguageLevel.current((Project)function.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && !containsArrayShapesAttribute) {
                        quickFixes.add(PhpAddArrayShapeQuickFix.INSTANCE);
                    }
                    if (!containsDocArrayShapes) {
                        quickFixes.add(PhpAddDocArrayShapeQuickFix.INSTANCE);
                    }
                    boolean bl = canBeHighlighted = PhpLanguageLevel.current((Project)function.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && !containsArrayShapesAttribute || !PhpLanguageLevel.current((Project)function.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && !containsDocArrayShapes;
                    if (canBeHighlighted) {
                        holder.registerProblem((PsiElement)function, nameIdentifier.getTextRangeInParent(), PhpBundle.message("inspection.message.arrayshape.can.be.added", new Object[0]), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    } else {
                        holder.registerProblem((PsiElement)function, PhpBundle.message("inspection.message.arrayshape.can.be.added", new Object[0]), ProblemHighlightType.INFORMATION, nameIdentifier.getTextRangeInParent(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                    }
                }
            }
        };
    }

    private static boolean containsDocArrayShapes(@NotNull Function function) {
        PhpDocComment comment;
        if (function == null) {
            PhpArrayShapeCanBeAddedInspection.$$$reportNull$$$0(1);
        }
        if ((comment = function.getDocComment()) == null) {
            return false;
        }
        PhpDocReturnTag returnTag = comment.getReturnTag();
        if (returnTag == null) {
            return false;
        }
        return !PhpDocArrayShapeProvider.getArrayShapesFromDoc(returnTag).isEmpty();
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getShapes(Function function) {
        final Ref shapes = new Ref(null);
        final Ref ambiguity = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                if (((Boolean)ambiguity.get()).booleanValue()) {
                    return false;
                }
                return super.processInstruction(instruction);
            }

            @Override
            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                List<PhpShapeEntriesIndex.PhpShapeEntry> currentShapes = PhpInferredArrayShapeRegistry.INSTANCE.getValues(instruction.getArgument(), false);
                if (currentShapes.isEmpty() || !shapes.isNull() && !currentShapes.equals(shapes.get())) {
                    ambiguity.set((Object)true);
                    return false;
                }
                shapes.set(currentShapes);
                return super.processReturnInstruction(instruction);
            }
        });
        return (Boolean)ambiguity.get() == false ? (Collection)shapes.get() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "containsDocArrayShapes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpAddArrayShapeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpAddArrayShapeQuickFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.arrayshape.attribute", new Object[0]);
            if (string == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes;
            if (project == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(3);
            }
            if ((shapes = PhpAddArrayShapeQuickFix.collapseSameKeys(PhpArrayShapeCanBeAddedInspection.getShapes(function = (Function)element))) == null) {
                return;
            }
            PhpAddArrayShapeQuickFix.insertAttribute(project, shapes, function, "\\JetBrains\\PhpStorm\\ArrayShape");
        }

        public static void insertAttribute(@NotNull Project project, Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes, PsiElement element, String attribute) {
            if (project == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(4);
            }
            PhpAttributesList attributeList = PhpPsiElementFactory.createAttributesList(project, String.format("%s([%s])", attribute, StringUtil.join(shapes, PhpAddArrayShapeQuickFix::getArrayHashElement, (String)", ")));
            PhpAttributesList addedArrayShapeAttribute = (PhpAttributesList)element.addBefore((PsiElement)attributeList, element.getFirstChild());
            PhpAttributeCanBeAddedToOverriddenMemberInspection.shortenClassReferences((PhpPsiElement)ContainerUtil.getFirstItem((Collection)addedArrayShapeAttribute.getAttributes()));
        }

        @Nullable
        public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> collapseSameKeys(@Nullable Collection<PhpShapeEntriesIndex.PhpShapeEntry> shapes) {
            if (shapes == null) {
                return null;
            }
            LinkedHashMap<PhpExpectedFunctionArgument, PhpShapeEntriesIndex.PhpShapeEntry> visited = new LinkedHashMap<PhpExpectedFunctionArgument, PhpShapeEntriesIndex.PhpShapeEntry>();
            for (PhpShapeEntriesIndex.PhpShapeEntry shape : shapes) {
                PhpExpectedFunctionArgument key = shape.getKey();
                if (visited.containsKey(key)) {
                    visited.put(key, new PhpShapeEntriesIndex.PhpShapeEntry(key, PhpType.or(shape.getType(), ((PhpShapeEntriesIndex.PhpShapeEntry)visited.get(key)).getType())));
                    continue;
                }
                visited.put(key, shape);
            }
            return visited.values();
        }

        @NlsSafe
        public static String getArrayHashElement(PhpShapeEntriesIndex.PhpShapeEntry shape) {
            PhpExpectedFunctionArgument key = shape.getKey();
            String keyValue = key instanceof PhpExpectedFunctionClassConstantArgument ? PhpAddArrayShapeQuickFix.getConstantValue((PhpExpectedFunctionClassConstantArgument)key) : key.getValue();
            return String.format("%s => \"%s\"", StringUtil.isQuotedString((String)keyValue) ? keyValue : StringUtil.wrapWithDoubleQuote((String)keyValue), shape.getType());
        }

        @NotNull
        private static String getConstantValue(PhpExpectedFunctionClassConstantArgument key) {
            String string = key.getClassFqn() + "::" + key.getConstantName();
            if (string == null) {
                PhpAddArrayShapeQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpAddArrayShapeQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpAddArrayShapeQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstantValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "insertAttribute";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpAddDocArrayShapeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpAddDocArrayShapeQuickFix();

        private PhpAddDocArrayShapeQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.arrayshape.to.doc", new Object[0]);
            if (string == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(3);
            }
            if ((function = (Function)ObjectUtils.tryCast((Object)element, Function.class)) == null) {
                return;
            }
            String arrayShape = PhpAddDocArrayShapeQuickFix.generateDocArrayShapeString(PhpAddArrayShapeQuickFix.collapseSameKeys(PhpArrayShapeCanBeAddedInspection.getShapes(function)));
            if (arrayShape == null) {
                return;
            }
            PhpDocComment comment = function.getDocComment();
            if (comment != null) {
                PhpDocReturnTag oldReturnTag = comment.getReturnTag();
                if (oldReturnTag != null) {
                    PhpAddDocArrayShapeQuickFix.updateReturnTag(oldReturnTag, arrayShape);
                } else {
                    PhpDocTag newReturnTag = PhpPsiElementFactory.createPhpDocTag(project, "@return %s".formatted(arrayShape));
                    comment.addAfter((PsiElement)newReturnTag, PhpPsiUtil.getChildOfType((PsiElement)comment, PhpDocTokenTypes.DOC_COMMENT_START));
                }
            } else {
                PhpAddDocArrayShapeQuickFix.addDocCommentWithArrayShapes(function, arrayShape);
            }
        }

        private static void updateReturnTag(@NotNull PhpDocReturnTag oldReturnTag, @NotNull String arrayShape) {
            if (oldReturnTag == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(4);
            }
            if (arrayShape == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(5);
            }
            PhpDocTag newTag = PhpPsiElementFactory.createPhpDocTag(oldReturnTag.getProject(), "@return %s %s".formatted(arrayShape, oldReturnTag.getTagValue()));
            oldReturnTag.replace((PsiElement)newTag);
        }

        private static void addDocCommentWithArrayShapes(@NotNull Function function, @NotNull String arrayShape) {
            PhpDocComment docComment;
            if (function == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(6);
            }
            if (arrayShape == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(7);
            }
            if ((docComment = PhpPsiElementFactory.createFromText(function.getProject(), PhpDocComment.class, "/**\n * %s\n */\n".formatted("@return " + arrayShape))) == null) {
                return;
            }
            function.getParent().addBefore((PsiElement)docComment, (PsiElement)function);
        }

        @NotNull
        private static String generateDocArrayShapeEntryString(@NotNull PhpShapeEntriesIndex.PhpShapeEntry arrayShapeEntry) {
            String children;
            String key;
            if (arrayShapeEntry == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(8);
            }
            if (!StringUtil.isQuotedString((String)(key = StringUtil.unquoteString((String)arrayShapeEntry.getKey().getValue()))) && key.contains(" ")) {
                key = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)key));
            }
            String string = StringUtil.isNotEmpty((String)(children = PhpAddDocArrayShapeQuickFix.generateDocArrayShapeString(arrayShapeEntry.getChildren()))) ? key + ": " + children : key + ": " + arrayShapeEntry.getType();
            if (string == null) {
                PhpAddDocArrayShapeQuickFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Nullable
        private static String generateDocArrayShapeString(Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapeEntries) {
            if (arrayShapeEntries == null || arrayShapeEntries.isEmpty()) {
                return null;
            }
            return "array{" + (String)StreamEx.of(arrayShapeEntries).map(e -> PhpAddDocArrayShapeQuickFix.generateDocArrayShapeEntryString(e)).collect(Collectors.joining(", ")) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpAddDocArrayShapeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldReturnTag";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayShape";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayShapeEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpAddDocArrayShapeQuickFix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateDocArrayShapeEntryString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateReturnTag";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addDocCommentWithArrayShapes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "generateDocArrayShapeEntryString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpInferredArrayShapeRegistry
    extends PhpAttributesRegistryBase<PhpShapeEntriesIndex.PhpShapeEntry> {
        static final PhpInferredArrayShapeRegistry INSTANCE = new PhpInferredArrayShapeRegistry();
        private static final int TYPE_LIMIT = 3;

        private PhpInferredArrayShapeRegistry() {
        }

        @Override
        public List<PhpShapeEntriesIndex.PhpShapeEntry> getValues(@Nullable PsiElement element, boolean allowAmbiguity) {
            if (element instanceof ArrayCreationExpression) {
                return PhpInferredArrayShapeRegistry.getValues((ArrayCreationExpression)element);
            }
            return super.getValues(element, allowAmbiguity);
        }

        @Override
        protected Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectValuesFromAssignments(final Variable element, PhpAccessVariableInstruction accessInstruction, final Ref<Boolean> ambiguous, final boolean allowAmbiguity) {
            final Collection<PhpShapeEntriesIndex.PhpShapeEntry> entries = super.collectValuesFromAssignments(element, accessInstruction, ambiguous, allowAmbiguity);
            if (((Boolean)ambiguous.get()).booleanValue()) {
                return Collections.emptyList();
            }
            PhpControlFlowUtil.processPredecessors(accessInstruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), element.getName()) || !instruction.getAccess().isWrite()) {
                        return true;
                    }
                    PsiElement instructionKey = instruction.getKey();
                    if (PhpInferredArrayShapeRegistry.isInapplicableKey(instructionKey)) {
                        ambiguous.set((Object)true);
                        if (!allowAmbiguity) {
                            this.haltTraversal();
                        }
                        return false;
                    }
                    PhpExpectedFunctionArgument key = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(instructionKey, 0, 0, null, false);
                    PhpType type = PhpInferredArrayShapeRegistry.getTypeForKey((PsiElement)PhpPsiUtil.getParentOfClass(instructionKey, ArrayAccessExpression.class));
                    entries.add(new PhpShapeEntriesIndex.PhpShapeEntry(key, type));
                    return super.processArrayAccessInstruction(instruction);
                }
            });
            return entries;
        }

        private static boolean isInapplicableKey(PsiElement instructionKey) {
            return instructionKey == null || !PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)instructionKey) || instructionKey instanceof Variable || instructionKey instanceof FieldReference;
        }

        private static List<PhpShapeEntriesIndex.PhpShapeEntry> getValues(ArrayCreationExpression array) {
            Iterator iterator = ArrayCreationExpressionImpl.children(array).iterator();
            int i = 0;
            ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> res = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>();
            while (iterator.hasNext()) {
                PhpPsiElement value;
                PhpPsiElement child = (PhpPsiElement)iterator.next();
                if (child instanceof ArrayHashElement && PhpInferredArrayShapeRegistry.isInapplicableKey((PsiElement)((ArrayHashElement)child).getKey())) {
                    return Collections.emptyList();
                }
                PhpExpectedFunctionArgument key = PhpShapeEntriesIndex.createShapeKeyFromArrayChild(child, i);
                PhpPsiElement phpPsiElement = value = child instanceof ArrayHashElement ? ((ArrayHashElement)child).getValue() : child.getFirstPsiChild();
                if (value instanceof ArrayCreationExpression) {
                    ArrayCreationExpression arrayCreation = (ArrayCreationExpression)value;
                    res.add(new PhpShapeEntriesIndex.PhpShapeEntry(key, PhpInferredArrayShapeRegistry.getTypeForKey((PsiElement)value), PhpInferredArrayShapeRegistry.getValues(arrayCreation)));
                } else {
                    res.add(new PhpShapeEntriesIndex.PhpShapeEntry(key, PhpInferredArrayShapeRegistry.getTypeForKey((PsiElement)value)));
                }
                ++i;
            }
            return res;
        }

        private static PhpType getTypeForKey(@Nullable PsiElement value) {
            if (value == null) {
                return PhpType.MIXED;
            }
            PhpType type = new PhpType().add(value).global(value.getProject());
            return type.hasUnknown() || type.size() > 3 ? PhpType.MIXED : type;
        }

        @Override
        @NotNull
        protected List<PhpShapeEntriesIndex.PhpShapeEntry> getValuesFromAssignedValue(@Nullable Variable variable, PsiElement value) {
            if (value instanceof ArrayCreationExpression) {
                List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpInferredArrayShapeRegistry.getValues((ArrayCreationExpression)value);
                if (list == null) {
                    PhpInferredArrayShapeRegistry.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = super.getValuesFromAssignedValue(variable, value);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpShapeEntriesIndex.PhpShapeEntry> getParameterValuesInner(@NotNull Function function, int argumentIndex) {
            if (function == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(2);
            }
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getParameterValues(function, argumentIndex);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpShapeEntriesIndex.PhpShapeEntry> getValuesInner(Function function) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getValues(function);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<PhpShapeEntriesIndex.PhpShapeEntry> getValues(Field field) {
            List<PhpShapeEntriesIndex.PhpShapeEntry> list = PhpArrayShapeRegistry.INSTANCE.getValues(field);
            if (list == null) {
                PhpInferredArrayShapeRegistry.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpInferredArrayShapeRegistry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValuesFromAssignedValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpArrayShapeCanBeAddedInspection$PhpInferredArrayShapeRegistry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterValuesInner";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValuesInner";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getParameterValuesInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

