/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpInapplicableAttributeTargetDeclarationInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpAttributeIsNotRepeatableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAttributeIsNotRepeatableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpAttributesOwner) {
                    this.doCheck((PhpAttributesOwner)element);
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void doCheck(@NotNull PhpAttributesOwner owner) {
                if (owner == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<@NotNull List> repeatedAttributes = StreamEx.of(owner.getAttributes()).groupingBy(attr -> StringUtil.notNullize((String)StringUtil.toLowerCase((String)attr.getFQN()))).entrySet().stream().filter(e -> StringUtil.isNotEmpty((String)((String)e.getKey()))).map(Map.Entry::getValue).filter(duplicates -> duplicates.size() > 1).toList();
                for (List attributes : repeatedAttributes) {
                    boolean isRepeatable;
                    List<@NotNull R> rootAttributes = attributes.stream().flatMap(attr -> PhpInapplicableAttributeTargetDeclarationInspection.getRootAttributes(attr).stream()).toList();
                    if (rootAttributes.isEmpty() || (isRepeatable = ContainerUtil.exists(rootAttributes, attr -> PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(attr.getArgumentsValues(), "IS_REPEATABLE")))) continue;
                    for (PhpAttribute attribute : attributes) {
                        holder.registerProblem((PsiElement)attribute, PhpBundle.message("inspection.message.attribute.is.not.repeatable", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitPhpField(Field field) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeIsNotRepeatableInspection$1", "doCheck"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpAttributeIsNotRepeatableInspection", "buildVisitor"));
    }
}

