/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpReplacePromotedFieldWithTraditionalQuickFix;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInapplicableAttributeTargetDeclarationInspection
extends PhpInspection {
    public boolean myStrictPromotedPropertyCheck = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpAttribute(PhpAttribute attribute) {
                Parameter parameter;
                List<@NotNull PhpAttribute> rootAttributes = PhpInapplicableAttributeTargetDeclarationInspection.getRootAttributes(attribute);
                PsiElement attributeOwner = attribute.getOwner();
                String inapplicableTargetDeclarationName = PhpInapplicableAttributeTargetDeclarationInspection.getInapplicableDeclarationName(attributeOwner, rootAttributes);
                if (inapplicableTargetDeclarationName != null) {
                    String requiredAttribute = "Attribute::TARGET_" + inapplicableTargetDeclarationName.toUpperCase(Locale.ENGLISH);
                    holder.registerProblem((PsiElement)attribute, PhpBundle.message("inspection.message.attribute.can.t.be.applied.to.because.it.doest.contains", inapplicableTargetDeclarationName, requiredAttribute), new LocalQuickFix[0]);
                } else if (PhpInapplicableAttributeTargetDeclarationInspection.this.myStrictPromotedPropertyCheck && attributeOwner instanceof Parameter && (parameter = (Parameter)attributeOwner).isPromotedField()) {
                    Collection<@NotNull PhpExpectedFunctionArgument> arguments = PhpInapplicableAttributeTargetDeclarationInspection.collectArguments(rootAttributes);
                    if (arguments == null) {
                        return;
                    }
                    boolean targetsParameter = PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PARAMETER");
                    if (!targetsParameter || !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PROPERTY")) {
                        String requiredAttribute = "Attribute::TARGET_" + (targetsParameter ? "PROPERTY" : "PARAMETER");
                        String message = PhpBundle.message("inspection.message.attribute.can.t.be.applied.to.because.it.doest.contains", PhpBundle.message("promoted.property", new Object[0]), requiredAttribute);
                        holder.problem((PsiElement)attribute, message).fix((ModCommandAction)new PhpReplacePromotedFieldWithTraditionalQuickFix(parameter)).register();
                    }
                }
            }
        };
    }

    public static String getInapplicableDeclarationName(@NotNull PsiElement declaration, Collection<@NotNull PhpAttribute> rootAttributes) {
        Collection<PhpExpectedFunctionArgument> arguments;
        if (declaration == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(1);
        }
        if ((arguments = PhpInapplicableAttributeTargetDeclarationInspection.collectArguments(rootAttributes)) == null) {
            return null;
        }
        return PhpInapplicableAttributeTargetDeclarationInspection.getInapplicableDeclarationName(arguments, declaration);
    }

    public static @Nullable Collection<@NotNull PhpExpectedFunctionArgument> collectArguments(Collection<@NotNull PhpAttribute> rootAttributes) {
        if (rootAttributes.isEmpty()) {
            return null;
        }
        HashSet<@NotNull PhpExpectedFunctionArgument> arguments = new HashSet<PhpExpectedFunctionArgument>();
        for (PhpAttribute rootAttribute : rootAttributes) {
            List<@NotNull PhpExpectedFunctionArgument> args = rootAttribute.getArgumentsValues();
            if (args.isEmpty()) {
                return null;
            }
            arguments.addAll(args);
        }
        return arguments;
    }

    @NotNull
    public static @NotNull List<@NotNull PhpAttribute> getRootAttributes(@NotNull PhpAttribute attribute) {
        ClassReference reference;
        if (attribute == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(2);
        }
        if ((reference = attribute.getClassReference()) == null) {
            List<PhpAttribute> list = Collections.emptyList();
            if (list == null) {
                PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = (List)((StreamEx)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).map(PhpInapplicableAttributeTargetDeclarationInspection::remapConstructorToClass).select(PhpClass.class).flatMap(c -> c.getAttributes().stream()).filter(attr -> PhpLangUtil.equalsClassNames(attr.getFQN(), "\\Attribute"))).collect(Collectors.toList());
        if (list == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static PsiElement remapConstructorToClass(PsiElement e) {
        return e instanceof Method && ((Method)e).getMethodType(false) == Method.MethodType.CONSTRUCTOR ? ((Method)e).getContainingClass() : e;
    }

    @Nls
    private static String getInapplicableDeclarationName(Collection<PhpExpectedFunctionArgument> arguments, PsiElement declaration) {
        if (PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_ALL")) {
            return null;
        }
        if (declaration instanceof PhpClass) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_CLASS") ? PhpBundle.message("class2", new Object[0]) : null;
        }
        if (declaration instanceof Method) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_METHOD") ? PhpBundle.message("method1", new Object[0]) : null;
        }
        if (declaration instanceof Function) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_FUNCTION") ? PhpBundle.message("function", new Object[0]) : null;
        }
        if (declaration instanceof PhpClassConstantsListImpl) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_CLASS_CONSTANT") ? PhpBundle.message("class.constant1", new Object[0]) : null;
        }
        if (declaration instanceof PhpClassFieldsList) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PROPERTY") ? PhpBundle.message("property", new Object[0]) : null;
        }
        if (declaration instanceof Parameter && ((Parameter)declaration).isPromotedField()) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PROPERTY") && !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PARAMETER") ? PhpBundle.message("property", new Object[0]) : null;
        }
        if (declaration instanceof Parameter) {
            return !PhpInapplicableAttributeTargetDeclarationInspection.existsRootDeclaration(arguments, "TARGET_PARAMETER") ? PhpBundle.message("parameter1", new Object[0]) : null;
        }
        return null;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myStrictPromotedPropertyCheck", (String)PhpBundle.message("label.highlight.target.parameter.attributes.applied.to.promoted.property", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpInapplicableAttributeTargetDeclarationInspection.$$$reportNull$$$0(5);
        }
        return optPane;
    }

    public static boolean existsRootDeclaration(Collection<PhpExpectedFunctionArgument> arguments, String aClass) {
        return ContainerUtil.exists(arguments, a -> a instanceof PhpExpectedFunctionClassConstantArgument && PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(((PhpExpectedFunctionClassConstantArgument)a).getClassFqn()), "\\Attribute") && PhpLangUtil.equalsClassConstantNames(((PhpExpectedFunctionClassConstantArgument)a).getConstantName(), aClass));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/attributes/PhpInapplicableAttributeTargetDeclarationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/attributes/PhpInapplicableAttributeTargetDeclarationInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInapplicableDeclarationName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRootAttributes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

