/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpRemoveAttributeQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTriviallyPureFunctionsIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPureFunctionMayProduceSideEffectsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPureFunctionMayProduceSideEffectsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public void visitPhpFunction(Function function) {
                PhpTriviallyPureFunctionsIndex.PurityType targetPurityType;
                @NotNull Collection pureAttributes = function.getAttributes("\\JetBrains\\PhpStorm\\Pure");
                if (pureAttributes.isEmpty()) {
                    return;
                }
                PhpTriviallyPureFunctionsIndex.PurityType purityType = targetPurityType = ContainerUtil.exists((Iterable)pureAttributes, PhpSideEffectDetector::isUsingGlobalScope) ? PhpTriviallyPureFunctionsIndex.PurityType.PURE_GLOBAL : PhpTriviallyPureFunctionsIndex.PurityType.PURE_LOCAL;
                if (PhpTriviallyPureFunctionsIndex.getPurityType(function, (Ref<Boolean>)new Ref((Object)false), (Ref<Boolean>)new Ref((Object)false), true) != targetPurityType && !this.hasUnresolvedCall(function)) {
                    this.registerErrorsOnAttributes(function, pureAttributes);
                }
            }

            private void registerErrorsOnAttributes(Function function, Collection<@NotNull PhpAttribute> pureAttributes) {
                String template = function instanceof Method ? PhpBundle.message("inspection.message.method.may.produce.side.effects", new Object[0]) : PhpBundle.message("inspection.message.function.may.produce.side.effects", new Object[0]);
                for (PhpAttribute attribute : pureAttributes) {
                    ClassReference reference = attribute.getClassReference();
                    if (reference == null) continue;
                    holder.problem((PsiElement)reference, template).fix((ModCommandAction)new PhpRemoveAttributeQuickFix(attribute)).register();
                }
            }

            private boolean hasUnresolvedCall(Function function) {
                final Ref hasUnresolvedCall = new Ref((Object)false);
                PhpControlFlowUtil.processSuccessors(function.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

                    @Override
                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        if (instruction.getFunctionReference().multiResolve(false).length == 0) {
                            hasUnresolvedCall.set((Object)true);
                            return false;
                        }
                        return super.processPhpCallInstruction(instruction);
                    }
                });
                return (Boolean)hasUnresolvedCall.get();
            }

            @Override
            public void visitPhpMethod(Method method) {
                this.visitPhpFunction(method);
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/attributes/PhpPureFunctionMayProduceSideEffectsInspection", "buildVisitor"));
    }
}

