/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.actions.generation.PhpOverrideImplementMethodsHandlerBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpDeprecatedSerializableUsageInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.classes.PhpImplementCallMagicMethodsHandler;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddMethodStubsQuickFix
extends PhpQuickFixBase {
    @NotNull
    public String getName() {
        String string = PhpBundle.message("intention.name.add.method.stubs", new Object[0]);
        if (string == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpOverrideImplementMethodsHandlerBase.MethodsToOverrideInfo selectedMethods;
        PsiElement element;
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(3);
        }
        if (!((element = descriptor.getPsiElement()) instanceof PhpClass)) {
            return;
        }
        PhpClass klass = (PhpClass)element;
        String error = PhpAddMethodStubsQuickFix.validateClass(project, klass);
        if (StringUtil.isNotEmpty((String)error)) {
            PhpAddMethodStubsQuickFix.showErrorMessage(project, error, element);
            return;
        }
        Map<String, Method> methodsToImplement = PhpAddMethodStubsQuickFix.getAbstractMethodsFromSuperClass(klass);
        methodsToImplement.putAll(PhpAddMethodStubsQuickFix.getAbstractHooksFromSuperClass(klass));
        if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP810) && PhpDeprecatedSerializableUsageInspection.implementsSerializable(klass)) {
            List<Method> serializeMagicMethods = PhpDeprecatedSerializableUsageInspection.getSerializeMagicMethods(project);
            serializeMagicMethods.forEach(m -> methodsToImplement.put(m.getName(), (Method)m));
        }
        if ((selectedMethods = PhpOverrideImplementMethodsHandlerBase.selectMethodsToOverride(project, methodsToImplement, PhpBundle.message("choose.methods.to.implement", new Object[0]), true)) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> PhpAddMethodStubsQuickFix.addMethodStubs(project, klass, selectedMethods.getSelectedMembers(), selectedMethods.getDocOption(), selectedMethods.isAddOverride()));
    }

    public static Map<String, Method> getAbstractMethodsFromSuperClass(@NotNull PhpClass klass) {
        if (klass == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(4);
        }
        HashMap<String, Method> methodsToImplement = new HashMap<String, Method>();
        Collection<Method> methods = klass.getMethods();
        for (Method method : methods) {
            if (!method.isAbstract()) continue;
            methodsToImplement.put(method.getName(), method);
        }
        return methodsToImplement;
    }

    public static Map<String, PhpPropertyHook> getAbstractHooksFromSuperClass(@NotNull PhpClass klass) {
        List<PhpPropertyHook> abstractHooks;
        if (klass == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(5);
        }
        if ((abstractHooks = PhpHierarchyChecksInspection.getNonImplementedPropertyHooks(klass)).isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, PhpPropertyHook> abstractHooksMap = new HashMap<String, PhpPropertyHook>();
        abstractHooks.forEach(hook -> abstractHooksMap.put(hook.getName(), (PhpPropertyHook)hook));
        return abstractHooksMap;
    }

    public static void addMethodStubs(@NotNull Project project, @NotNull PhpClass klass, @NotNull Collection<Method> methodsToImplement) {
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(6);
        }
        if (klass == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(7);
        }
        if (methodsToImplement == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(8);
        }
        PhpAddMethodStubsQuickFix.addMethodStubs(project, klass, methodsToImplement, PhpDocCreationOption.INHERIT, false);
    }

    public static void addMethodStubs(@NotNull Project project, @NotNull PhpClass klass, @NotNull Collection<Method> methodsToImplement, @NotNull PhpDocCreationOption docCreationOption, boolean addOverride) {
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(9);
        }
        if (klass == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(10);
        }
        if (methodsToImplement == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(11);
        }
        if (docCreationOption == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(12);
        }
        List filteredMethodsToImplement = ContainerUtil.filter(methodsToImplement, m -> PhpHierarchyChecksInspection.shouldAddMethodStub(m, klass));
        PhpOverrideImplementMethodsHandlerBase.PhpIgnoreInternalAttributesReferenceResolver referenceResolver = new PhpOverrideImplementMethodsHandlerBase.PhpIgnoreInternalAttributesReferenceResolver();
        for (Method method : filteredMethodsToImplement) {
            boolean docOption = docCreationOption == PhpDocCreationOption.COPY_ALWAYS || docCreationOption == PhpDocCreationOption.DEFAULT || docCreationOption == PhpDocCreationOption.COPY_IF_ABSTRACT && method.isAbstract();
            referenceResolver.processElement(method, docOption);
        }
        List<PsiElement> insertedStubs = PhpAddMethodStubsQuickFix.insertFieldsWithPropertyHooks(klass, ContainerUtil.filterIsInstance(methodsToImplement, PhpPropertyHook.class), project, addOverride);
        PhpImplementCallMagicMethodsHandler magicMethodsHandler = null;
        for (Method m2 : PhpAddMethodStubsQuickFix.orderMethodsAsInOriginalFiles(filteredMethodsToImplement)) {
            if (m2 instanceof PhpDocMethod) {
                if (magicMethodsHandler == null) {
                    magicMethodsHandler = new PhpImplementCallMagicMethodsHandler(project, klass);
                }
                magicMethodsHandler.addDocMethod((PhpDocMethod)m2);
                continue;
            }
            PsiElement inserted = PhpAddMethodStubsQuickFix.addMethodStub(klass, m2, docCreationOption, addOverride);
            if (inserted == null) continue;
            insertedStubs.add(inserted);
        }
        if (magicMethodsHandler != null) {
            PsiElement overridenMethodCall;
            PsiElement docComment = magicMethodsHandler.updateClassDoc();
            if (docComment != null) {
                insertedStubs.add(docComment);
            }
            if ((overridenMethodCall = magicMethodsHandler.overrideCallMethodIfNeeded()) != null) {
                insertedStubs.add(overridenMethodCall);
            }
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)klass);
        assert (scopeHolder != null);
        referenceResolver.importReferences(scopeHolder, insertedStubs);
    }

    private static List<PsiElement> insertFieldsWithPropertyHooks(PhpClass klass, Collection<PhpPropertyHook> abstractHooks, Project project, boolean addOverride) {
        ArrayList<PsiElement> insertedFields = new ArrayList<PsiElement>();
        HashSet visited = new HashSet();
        Field[] fields = klass.getOwnFields();
        abstractHooks.forEach(hook -> {
            Field superField = hook.getContainingField();
            if (superField == null) {
                return;
            }
            if (!visited.add(superField.getName())) {
                return;
            }
            Field ownField = (Field)ContainerUtil.find((Object[])fields, f -> f.getName().equals(superField.getName()));
            PsiElement inserted = null;
            if (ownField != null) {
                Set implementedHookTypes = ownField.getPropertyHooksList().stream().filter(it -> !it.isAbstract()).map(PhpPropertyHook::getHookType).collect(Collectors.toSet());
                superField.getPropertyHooksList().forEach(it -> {
                    PhpPropertyHook.PhpPropertyHookType hookType = it.getHookType();
                    if (implementedHookTypes.contains((Object)hookType) || !abstractHooks.contains(it)) {
                        return;
                    }
                    PhpPropertyHook existingAbstractHook = (PhpPropertyHook)ContainerUtil.find(ownField.getPropertyHooksList(), h -> h.getHookType() == hookType);
                    String attributesText = existingAbstractHook != null ? PhpCodeUtil.getAttributeTextForOverride(existingAbstractHook, addOverride) : (addOverride ? "\\Override" : "");
                    PhpPropertyHook createdHook = PhpPsiElementFactory.createPropertyHook(superField.getProject(), hookType, superField.getName(), attributesText);
                    PsiElement existingHooks = FieldImpl.getPropertyHooksContainer(ownField);
                    if (existingHooks != null) {
                        if (existingAbstractHook != null) {
                            existingAbstractHook.replace(createdHook);
                        } else {
                            existingHooks.addAfter((PsiElement)createdHook, existingHooks.getFirstChild());
                        }
                    }
                });
            } else {
                PhpPsiElement newClassField = PhpAddMethodStubsQuickFix.createClassFieldWithSuperFieldPropertyHooks(project, superField, abstractHooks, addOverride);
                inserted = klass.addBefore((PsiElement)newClassField, klass.getLastChild());
            }
            insertedFields.add(inserted);
        });
        return insertedFields;
    }

    private static PhpPsiElement createClassFieldWithSuperFieldPropertyHooks(Project project, Field superField, Collection<PhpPropertyHook> abstractHooks, boolean addOverride) {
        StringBuilder builder2 = new StringBuilder();
        superField.getPropertyHooksList().forEach(hook -> {
            if (!abstractHooks.contains(hook)) {
                return;
            }
            builder2.append(PhpCodeUtil.getAttributeTextForOverride(hook, addOverride));
            String hookText = PhpCodeUtil.getPropertyHookText(superField.getName(), hook.getHookType());
            builder2.append(hookText);
        });
        String hooks = builder2.isEmpty() ? null : "{" + builder2 + "}";
        PhpModifier superModifier = superField.getModifier();
        PhpModifier modifier = PhpModifier.instance(superModifier.getAccess(), PhpModifier.Abstractness.IMPLEMENTED, superModifier.getState());
        return PhpPsiElementFactory.createClassField(project, modifier, superField.isReadonly(), superField.getName(), PhpMoveClassMemberBase.getDefaultValueText(superField), superField.getDeclaredType().toString(), hooks);
    }

    @Nullable
    public static PsiElement addMethodStub(PhpClass klass, Method method, PhpDocCreationOption option, boolean addOverride) {
        PsiElement insertedMethod = null;
        String template = PhpCodeUtil.createOverridingMethodText(klass, method, option, addOverride);
        PhpClass container = PhpCodeUtil.createClassFromMethodTemplate(klass, klass.getProject(), template);
        if (container != null) {
            for (PhpPsiElement childElement = container.getFirstPsiChild(); childElement != null; childElement = childElement.getNextSibling()) {
                ASTNode childNode = childElement.getNode();
                if (childNode == null) continue;
                if (childElement instanceof PhpDocComment) {
                    klass.addBefore((PsiElement)childElement, klass.getLastChild());
                }
                if (childNode.getElementType() != PhpStubElementTypes.CLASS_METHOD) continue;
                insertedMethod = klass.addBefore((PsiElement)childElement, klass.getLastChild());
            }
        }
        return insertedMethod;
    }

    public static Collection<Method> orderMethodsAsInOriginalFiles(Collection<Method> members) {
        members = new ArrayList<Method>(members);
        ((List)members).sort((o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getOriginalElement();
            PsiElement psiElement2 = o2.getOriginalElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return members;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(13);
        }
        if (previewDescriptor == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(14);
        }
        return new IntentionPreviewInfo.Html(PhpBundle.message("shows.dialog.with.methods.from.implemented.interface.selected.methods.will.be.inserted.into.the.class.after.dialog.confirmation", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpAddMethodStubsQuickFix";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsToImplement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docCreationOption";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpAddMethodStubsQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractMethodsFromSuperClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractHooksFromSuperClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addMethodStubs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }
}

