/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpImplementCallMagicMethodsHandler {
    private final List<String> docMethodDefs;
    @NotNull
    private final PhpClass myPhpClass;
    @NotNull
    private final Project myProject;

    PhpImplementCallMagicMethodsHandler(@NotNull Project project, @NotNull PhpClass phpClass) {
        if (project == null) {
            PhpImplementCallMagicMethodsHandler.$$$reportNull$$$0(0);
        }
        if (phpClass == null) {
            PhpImplementCallMagicMethodsHandler.$$$reportNull$$$0(1);
        }
        this.docMethodDefs = new ArrayList<String>();
        this.myPhpClass = phpClass;
        this.myProject = project;
    }

    void addDocMethod(@NotNull PhpDocMethod method) {
        if (method == null) {
            PhpImplementCallMagicMethodsHandler.$$$reportNull$$$0(2);
        }
        this.docMethodDefs.add(PhpImplementCallMagicMethodsHandler.getDocMethodDef(method));
    }

    @NotNull
    private static String getDocMethodDef(@NotNull PhpDocMethod docMethod) {
        if (docMethod == null) {
            PhpImplementCallMagicMethodsHandler.$$$reportNull$$$0(3);
        }
        StringBuilder result = new StringBuilder();
        PsiElement methodType = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(docMethod, true);
        String typeStr = PhpPsiUtil.isOfType(methodType, (IElementType)PhpDocElementTypes.phpDocMethodType) ? methodType.getText() : docMethod.getGlobalType().toStringResolved();
        String string = result.append("@method").append(' ').append(typeStr).append(' ').append(docMethod.getText()).toString();
        if (string == null) {
            PhpImplementCallMagicMethodsHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    PsiElement overrideCallMethodIfNeeded() {
        for (Method method : this.myPhpClass.getOwnMethods()) {
            if (!"__call".equals(method.getName())) continue;
            return null;
        }
        PhpClass obj = PhpClassHierarchyUtils.getObject(this.myProject);
        Method callMethod = null;
        if (obj != null) {
            for (Method method : obj.getMethods()) {
                if (!"__call".equals(method.getName())) continue;
                callMethod = method;
                break;
            }
        }
        if (callMethod != null && this.docMethodDefs.size() > 0) {
            StringBuilder methodBody = new StringBuilder();
            String lastDef = this.docMethodDefs.get(this.docMethodDefs.size() - 1);
            for (String methodDef : this.docMethodDefs) {
                methodBody.append(" // TODO: Implement ").append(methodDef);
                if (Strings.areSameInstance((String)methodDef, (String)lastDef)) continue;
                methodBody.append('\n');
            }
            String callMethodText = PhpLanguageLevel.current((Project)this.myProject).isAtLeast(PhpLanguageLevel.PHP800) ? PhpCodeUtil.createOverridingMethodText(this.myPhpClass, callMethod, methodBody.toString(), PhpDocCreationOption.COPY_IF_ABSTRACT, false) : PhpCodeUtil.createOverridingMethodTextWithoutTypeDeclarations(callMethod, methodBody.toString(), PhpDocCreationOption.COPY_IF_ABSTRACT, false);
            Method newCallMethod = PhpPsiElementFactory.createMethod(this.myProject, callMethodText);
            PsiElement insertBefore = this.myPhpClass.getLastChild();
            if (PhpPsiUtil.isOfType(insertBefore, PhpTokenTypes.chRBRACE)) {
                return this.myPhpClass.addBefore(newCallMethod, insertBefore);
            }
        }
        return null;
    }

    @Nullable
    PsiElement updateClassDoc() {
        PhpDocComment docComment = this.myPhpClass.getDocComment();
        StringBuilder docCommentTemplate = new StringBuilder();
        docCommentTemplate.append("<?php\n/**\n");
        for (String docMethodDef : this.docMethodDefs) {
            docCommentTemplate.append("* ").append(docMethodDef).append('\n');
        }
        docCommentTemplate.append("*/");
        PhpDocComment newDocComment = PhpPsiElementFactory.createFromText(this.myProject, PhpDocComment.class, docCommentTemplate.toString());
        if (newDocComment != null) {
            if (docComment == null) {
                return this.myPhpClass.getParent().addBefore((PsiElement)newDocComment, (PsiElement)this.myPhpClass);
            }
            PsiElement insertAfter = docComment.getLastChild();
            if (PhpPsiUtil.isOfType(insertAfter, PhpDocTokenTypes.DOC_COMMENT_END)) {
                if ((insertAfter = insertAfter.getPrevSibling()) instanceof PsiWhiteSpace) {
                    insertAfter = insertAfter.getPrevSibling();
                }
                if (insertAfter != null) {
                    PsiElement newDocChild = newDocComment.getLastChild();
                    if (PhpPsiUtil.isOfType(newDocChild, PhpDocTokenTypes.DOC_COMMENT_END) && (newDocChild = newDocChild.getPrevSibling()) instanceof PsiWhiteSpace) {
                        newDocChild = newDocChild.getPrevSibling();
                    }
                    while (newDocChild != null) {
                        IElementType childType = newDocChild.getNode().getElementType();
                        if (childType != PhpDocTokenTypes.DOC_COMMENT_START) {
                            docComment.addAfter(newDocChild, insertAfter);
                        }
                        newDocChild = newDocChild.getPrevSibling();
                    }
                }
            }
            return docComment;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpImplementCallMagicMethodsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpImplementCallMagicMethodsHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocMethodDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDocMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDocMethodDef";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

