/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamedArgumentMightBeUnresolvedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNamedArgumentMightBeUnresolvedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                PsiElement[] arguments = reference.getParameters();
                Collection namedArguments = Arrays.stream(arguments).map(argument -> Pair.create((Object)argument, (Object)ParameterListImpl.getNameIdentifier(argument))).filter(p -> p.second != null).collect(Collectors.toSet());
                if (namedArguments.isEmpty()) {
                    return;
                }
                PhpExpression classReference = reference.getClassReference();
                if (MethodReferenceImpl.isSelfOrParentReference(classReference)) {
                    return;
                }
                for (Function function : PhpAnnotatorVisitor.resolveFunctions(reference)) {
                    List<Parameter> parameters;
                    PhpClass containingClass;
                    if (namedArguments.isEmpty()) {
                        return;
                    }
                    if (!(function instanceof Method) || function instanceof PhpDocMethod || (containingClass = ((Method)function).getContainingClass()) == null || containingClass.isTrait() || containingClass.isFinal() || ContainerUtil.exists(parameters = Arrays.asList(function.getParameters()), Parameter::isVariadic)) continue;
                    HashSet<Pair> checkedElements = new HashSet<Pair>();
                    for (Pair argument2 : namedArguments) {
                        PhpClass aClass;
                        Parameter parameter = (Parameter)ContainerUtil.find(parameters, p -> PhpLangUtil.equalsParameterNames(p.getName(), ((PsiElement)argument.second).getText()));
                        Method methodWithParameterDifferentName = parameter != null ? PhpNamedArgumentMightBeUnresolvedInspection.findOverridingMethodWithParameterDifferentName((Method)function, parameter.getName()) : PhpNamedArgumentMightBeUnresolvedInspection.findOverridingMethodWithParameterName((Method)function, ((PsiElement)argument2.second).getText());
                        if (methodWithParameterDifferentName == null) continue;
                        PhpClass phpClass = aClass = parameter != null ? methodWithParameterDifferentName.getContainingClass() : containingClass;
                        assert (aClass != null);
                        holder.registerProblem((PsiElement)argument2.second, PhpBundle.message("inspection.message.name.parameter.may.be.different.depending.on.instance.class", aClass.getPresentableFQN(), methodWithParameterDifferentName.getName()), new LocalQuickFix[0]);
                        checkedElements.add(argument2);
                    }
                    namedArguments.removeAll(checkedElements);
                }
            }
        };
    }

    @Nullable
    private static Method findOverridingMethodWithParameterName(Method method, String argumentName) {
        return PhpNamedArgumentMightBeUnresolvedInspection.findOverridingMethod(method, member -> ContainerUtil.exists((Object[])member.getParameters(), p -> p.isVariadic() || PhpLangUtil.equalsParameterNames(argumentName, p.getName())));
    }

    @Nullable
    private static Method findOverridingMethodWithParameterDifferentName(Method method, String parameterName) {
        return PhpNamedArgumentMightBeUnresolvedInspection.findOverridingMethod(method, member -> !ContainerUtil.exists((Object[])member.getParameters(), p -> p.isVariadic() || PhpLangUtil.equalsParameterNames(parameterName, p.getName())));
    }

    @Nullable
    private static Method findOverridingMethod(Method method, final Predicate<Method> predicate) {
        final Ref res = new Ref(null);
        PhpClassHierarchyUtils.processOverridingMethods(method, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<? super Method>)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<Method>(){

            @Override
            public boolean process(Method member, PhpClass subClass, PhpClass baseClass) {
                if (!(member instanceof PhpDocMethod) && predicate.test(member)) {
                    res.set((Object)member);
                    return false;
                }
                return true;
            }
        });
        return (Method)res.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentMightBeUnresolvedInspection", "buildVisitor"));
    }
}

