/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNamedArgumentsWithChangedOrderInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpParameterList(ParameterList list) {
                List<PsiElement> arguments = Arrays.asList(list.getParameters());
                int firstIndex = ContainerUtil.indexOf(arguments, PhpNamedArgumentsWithChangedOrderInspection::isNamedArgument);
                if (firstIndex == ContainerUtil.lastIndexOf(arguments, PhpNamedArgumentsWithChangedOrderInspection::isNamedArgument)) {
                    return;
                }
                Collection<List<Parameter>> parameters = PhpNamedArgumentsWithChangedOrderInspection.resolveParameters(list);
                if (parameters.isEmpty() || ContainerUtil.exists(parameters, Collection::isEmpty)) {
                    return;
                }
                if (ContainerUtil.and(parameters, p -> !PhpNamedArgumentsWithChangedOrderInspection.argumentsAlreadySorted(arguments, firstIndex, p))) {
                    PsiElement identifier = ParameterListImpl.getNameIdentifier(arguments.get(firstIndex));
                    if (identifier == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)list, TextRange.create((int)identifier.getTextRangeInParent().getStartOffset(), (int)((PsiElement)ContainerUtil.getLastItem(arguments)).getTextRangeInParent().getEndOffset()), PhpBundle.message("inspection.php.named.arguments.with.changed.order", new Object[0]), new LocalQuickFix[]{PhpSortArgumentsQuickFix.INSTANCE});
                }
            }
        };
    }

    @NotNull
    private static Collection<List<Parameter>> resolveParameters(ParameterList list) {
        ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        Collection<Object> function = owner != null ? PhpAnnotatorVisitor.resolveFunctions(owner) : Collections.emptyList();
        List list2 = ContainerUtil.map(function, f -> Arrays.asList(f.getParameters()));
        if (list2 == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public static boolean isNamedArgument(PsiElement a) {
        return ParameterListImpl.getNameIdentifier(a) != null;
    }

    private static boolean argumentsAlreadySorted(List<PsiElement> arguments, int index, List<Parameter> parameters) {
        int lastIndex = -1;
        for (int i = index; i < arguments.size(); ++i) {
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            if (nameIdentifier == null) {
                return true;
            }
            int parameterIndex = PhpWorkaroundUtil.resolveMappedParameterIndex(nameIdentifier.getText(), parameters);
            if (parameterIndex < 0) {
                return true;
            }
            if (parameterIndex < lastIndex) {
                return false;
            }
            lastIndex = parameterIndex;
        }
        return true;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    public static void sortNamedArguments(@NotNull Project project, ParameterList list) {
        List<PsiElement> arguments;
        int index;
        if (project == null) {
            PhpNamedArgumentsWithChangedOrderInspection.$$$reportNull$$$0(2);
        }
        if ((index = ContainerUtil.indexOf(arguments = Arrays.asList(list.getParameters()), PhpNamedArgumentsWithChangedOrderInspection::isNamedArgument)) < 0) {
            return;
        }
        List<Pair> sortedArguments = IntStream.range(index, arguments.size()).mapToObj(arguments::get).sorted(Comparator.comparingInt(PhpWorkaroundUtil::resolveMappedParameterIndex)).map(a -> Pair.create((Object)Objects.requireNonNull(ParameterListImpl.getNameIdentifier(a)).getText(), (Object)a.copy())).toList();
        for (int i = index; i < arguments.size(); ++i) {
            Pair sortedPair = sortedArguments.get(i - index);
            PsiElement identifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            assert (identifier != null);
            identifier.replace(PhpPsiElementFactory.createNamedArgumentNameIdentifier(project, (String)sortedPair.getFirst()));
            arguments.get(i).replace((PsiElement)sortedPair.getSecond());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sortNamedArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class PhpSortArgumentsQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpSortArgumentsQuickFix();

        private PhpSortArgumentsQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.sort.arguments", new Object[0]);
            if (string == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            ParameterList list;
            if (project == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpSortArgumentsQuickFix.$$$reportNull$$$0(3);
            }
            if ((list = PhpPsiUtil.getParentOfClass(element, false, ParameterList.class)) == null) {
                return;
            }
            PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, list);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection$PhpSortArgumentsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpNamedArgumentsWithChangedOrderInspection$PhpSortArgumentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

