/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpNamedArgumentsWithChangedOrderInspection;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArraySearchInBooleanContextInspection
extends PhpInspection {
    private static final TokenSet STRICT_COMPARISON = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opIDENTICAL, PhpTokenTypes.opNOT_IDENTICAL});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArraySearchInBooleanContextInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                ASTNode nameNode;
                Boolean inArrayNegated;
                if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "array_search") && (inArrayNegated = PhpArraySearchInBooleanContextInspection.getInArrayNegation((PsiElement)reference, true)) != null && (nameNode = reference.getNameNode()) != null) {
                    FunctionReference elementToReplace = reference.getParent() instanceof AssignmentExpression ? reference : reference.getParent();
                    holder.problem(nameNode.getPsi(), PhpBundle.message("inspection.message.can.be.replaced.with.in.array.call", inArrayNegated != false ? "!in_array" : "in_array")).fix((ModCommandAction)new PhpReplaceWithInArrayCallQuickFix(reference, (PsiElement)elementToReplace, inArrayNegated)).register();
                }
            }
        };
    }

    @Nullable
    private static Boolean getInArrayNegation(PsiElement element, boolean checkVariablesAssignment) {
        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(element, false, AssignmentExpression.INSTANCEOF, Statement.INSTANCEOF);
        if (assignment != null && assignment.getValue() == element && checkVariablesAssignment) {
            PhpAccessVariableInstruction instruction;
            PsiElement parent = assignment.getParent();
            if (!(parent instanceof StatementImpl) || parent.getChildren().length != 1 || parent.getFirstChild() != assignment) {
                return null;
            }
            Variable variable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class);
            PhpAccessVariableInstruction phpAccessVariableInstruction = instruction = variable != null ? PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class) : null;
            if (instruction != null) {
                return PhpArraySearchInBooleanContextInspection.allVariableUsagesAreInFalseComparisonContext(variable, instruction) ? Boolean.FALSE : null;
            }
        }
        return PhpArraySearchInBooleanContextInspection.getNegationFromFalseComparisonContext(element, checkVariablesAssignment);
    }

    @Nullable
    private static Boolean getNegationFromFalseComparisonContext(PsiElement element, boolean checkVariablesAssignment) {
        IElementType operationType;
        PsiElement parent = element.getParent();
        if (parent instanceof ParenthesizedExpression) {
            return PhpArraySearchInBooleanContextInspection.getInArrayNegation(parent, checkVariablesAssignment);
        }
        if (parent instanceof BinaryExpression && STRICT_COMPARISON.contains(operationType = ((BinaryExpression)parent).getOperationType())) {
            PsiElement oppositeOperand;
            PsiElement leftOperand = ((BinaryExpression)parent).getLeftOperand();
            PsiElement rightOperand = ((BinaryExpression)parent).getRightOperand();
            Object object = leftOperand == element ? rightOperand : (oppositeOperand = rightOperand == element ? leftOperand : null);
            if (PhpLangUtil.isFalse(oppositeOperand)) {
                return operationType == PhpTokenTypes.opIDENTICAL;
            }
        }
        return null;
    }

    private static boolean allVariableUsagesAreInFalseComparisonContext(final Variable variable, PhpAccessVariableInstruction instruction) {
        final Ref nonBooleanContextExists = new Ref((Object)false);
        final Ref usagesExists = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName()) && instruction.getAnchor() != variable) {
                    if (!instruction.getAccess().isRead()) {
                        return false;
                    }
                    usagesExists.set((Object)true);
                    if (PhpArraySearchInBooleanContextInspection.getInArrayNegation((PsiElement)instruction.getAnchor(), false) == null) {
                        nonBooleanContextExists.set((Object)true);
                        return false;
                    }
                }
                return true;
            }
        });
        return (Boolean)nonBooleanContextExists.get() == false && (Boolean)usagesExists.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpArraySearchInBooleanContextInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithInArrayCallQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final boolean myInArrayNegated;
        @NotNull
        private final SmartPsiElementPointer<FunctionReference> myFunctionPointer;

        private PhpReplaceWithInArrayCallQuickFix(FunctionReference reference, PsiElement elementToReplace, boolean inArrayNegated) {
            super(elementToReplace);
            this.myFunctionPointer = SmartPointerManager.createPointer((PsiElement)reference);
            this.myInArrayNegated = inArrayNegated;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement elementToReplace, @NotNull ModPsiUpdater updater) {
            FunctionReference arraySearchCall;
            if (context == null) {
                PhpReplaceWithInArrayCallQuickFix.$$$reportNull$$$0(0);
            }
            if (elementToReplace == null) {
                PhpReplaceWithInArrayCallQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceWithInArrayCallQuickFix.$$$reportNull$$$0(2);
            }
            if ((arraySearchCall = (FunctionReference)this.myFunctionPointer.getElement()) == null) {
                return;
            }
            ParameterList parameterList = arraySearchCall.getParameterList();
            if (parameterList == null) {
                return;
            }
            Project project = context.project();
            PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, parameterList);
            PhpUnitReplaceAssertMethodReferenceQuickFix.dropNameIdentifiers(parameterList);
            String functionReferenceText = "in_array(" + parameterList.getText() + ")";
            elementToReplace.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpExpression.class, this.myInArrayNegated ? "!" + functionReferenceText : functionReferenceText));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.in.array.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithInArrayCallQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReplace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArraySearchInBooleanContextInspection$PhpReplaceWithInArrayCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArraySearchInBooleanContextInspection$PhpReplaceWithInArrayCallQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

