/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBooleanUsageVisitor
extends PhpElementVisitor {
    @Override
    public void visitPhpIf(If ifStatement) {
        this.check((PsiElement)ifStatement.getCondition());
    }

    @Override
    public void visitPhpElseIf(ElseIf elseIfStatement) {
        this.check((PsiElement)elseIfStatement.getCondition());
    }

    @Override
    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.check((PsiElement)expression.getCondition());
    }

    @Override
    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.check((PsiElement)doWhileStatement.getCondition());
    }

    @Override
    public void visitPhpWhile(While whileStatement) {
        this.check((PsiElement)whileStatement.getCondition());
    }

    @Override
    public void visitPhpBinaryExpression(BinaryExpression expression) {
        if (PhpTokenTypes.tsLOGICAL_OPS.contains(expression.getOperationType())) {
            this.check(expression.getLeftOperand());
            this.check(expression.getRightOperand());
        }
    }

    @Override
    public void visitPhpUnaryExpression(UnaryExpression expr) {
        PsiElement operation = expr.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opNOT) || PhpPsiUtil.isOfType(operation, PhpTokenTypes.opBOOLEAN_CAST)) {
            this.check((PsiElement)expr.getValue());
        }
    }

    private void check(@Nullable PsiElement element) {
        if (element instanceof ParenthesizedExpression) {
            this.check((PsiElement)((ParenthesizedExpression)element).getArgument());
            return;
        }
        if (element == null) {
            return;
        }
        this.doCheck(element);
    }

    protected abstract void doCheck(@NotNull PsiElement var1);

    public static boolean isInBooleanUsageContext(final @Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        final Ref res = new Ref((Object)false);
        PhpBooleanUsageVisitor visitor = new PhpBooleanUsageVisitor(){

            @Override
            protected void doCheck(@NotNull PsiElement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == element) {
                    res.set((Object)true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/lang/inspections/codeSmell/PhpBooleanUsageVisitor$1", "doCheck"));
            }
        };
        PsiElement parent = element.getParent();
        while (parent instanceof ParenthesizedExpression) {
            parent = parent.getParent();
        }
        parent.accept((PsiElementVisitor)visitor);
        return (Boolean)res.get();
    }
}

