/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveProcessor;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PhpCaseInsensitiveVisitor
extends PhpElementVisitor {
    public void visitFunctionOrMethod(FunctionReference functionReference, PhpCaseInsensitiveProcessor processor) {
        String resolvedElementName;
        PsiElement resolvedElement;
        String referenceName = functionReference.getName();
        if (referenceName != null && (resolvedElement = functionReference.resolve()) instanceof Function && this.equalsCaseInsensitive(referenceName, resolvedElementName = ((Function)resolvedElement).getName())) {
            processor.process(functionReference, resolvedElementName);
        }
    }

    private PsiElement visitClassReference(ClassReference classReference, PhpCaseInsensitiveProcessor processor) {
        String resolvedElementName;
        String referenceName;
        PsiElement resolvedElement = classReference.resolve();
        if (resolvedElement instanceof PhpClass && (referenceName = classReference.getName()) != null && this.equalsCaseInsensitive(referenceName, resolvedElementName = ((PhpClass)resolvedElement).getName())) {
            processor.process(classReference, resolvedElementName);
        }
        return resolvedElement;
    }

    @Override
    public void visitPhpFunctionCall(FunctionReference functionReference) {
        super.visitPhpFunctionCall(functionReference);
        this.visitFunctionOrMethod(functionReference, this.getFunctionMethodProcessor());
    }

    @Override
    public void visitPhpMethodReference(MethodReference methodReference) {
        super.visitPhpMethodReference(methodReference);
        this.visitFunctionOrMethod(methodReference, this.getFunctionMethodProcessor());
    }

    @Override
    public void visitPhpClassReference(ClassReference classReference) {
        super.visitPhpClassReference(classReference);
        PsiElement resolvedElement = this.visitClassReference(classReference, this.getClassReferenceProcessor());
        this.visitClassReferenceInUseStatement(classReference, resolvedElement);
    }

    @Override
    public void visitPhpNamespaceReference(PhpNamespaceReference namespaceReference) {
        super.visitPhpNamespaceReference(namespaceReference);
        PsiReference[] references = namespaceReference.getReferences();
        if (references.length != 0) {
            PsiElement psiElement = references[references.length - 1].resolve();
            String referenceName = namespaceReference.getFullName();
            if (psiElement instanceof PhpNamespace) {
                String resolvedName = ((PhpNamespace)psiElement).getFQN();
                if (this.equalsCaseInsensitive(PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(referenceName), PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(resolvedName))) {
                    HashSet<String> usedNames = new HashSet<String>();
                    PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)namespaceReference);
                    if (scopeForUseOperator != null) {
                        List<PhpUseList> list = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
                        for (PhpUseList it : list) {
                            PhpUse[] declarations;
                            for (PhpUse declaration : declarations = it.getDeclarations()) {
                                String aliasName = declaration.getAliasName();
                                if (aliasName == null) continue;
                                usedNames.add(PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(aliasName));
                            }
                        }
                    }
                    if (!usedNames.contains(PhpCaseInsensitiveVisitor.cutFirstAndLastDelimeter(namespaceReference.getText()))) {
                        this.processNamespaceReference(namespaceReference, referenceName, resolvedName);
                    }
                }
            }
        }
    }

    public boolean equalsCaseInsensitive(@NotNull String referenceName, String resolvedElementName) {
        if (referenceName == null) {
            PhpCaseInsensitiveVisitor.$$$reportNull$$$0(0);
        }
        return !referenceName.equals(resolvedElementName) && referenceName.equalsIgnoreCase(resolvedElementName);
    }

    public static String cutFirstAndLastDelimeter(String namespaceReferenceName) {
        String answer = namespaceReferenceName;
        if (namespaceReferenceName.startsWith("\\")) {
            answer = answer.substring(1);
        }
        if (namespaceReferenceName.endsWith("\\")) {
            answer = answer.substring(0, answer.length() - 1);
        }
        return answer;
    }

    public static void replaceReferenceWithDelimeter(@NotNull Project project, PhpPsiElement reference, String namespaceReference, String resolvedElementName) {
        if (project == null) {
            PhpCaseInsensitiveVisitor.$$$reportNull$$$0(1);
        }
        Object replacementName = "";
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = reference.getContainingFile().getViewProvider().getDocument();
        if (namespaceReference.startsWith("\\") && !resolvedElementName.startsWith("\\")) {
            replacementName = (String)replacementName + "\\";
        }
        replacementName = (String)replacementName + resolvedElementName;
        if (namespaceReference.endsWith("\\") && !resolvedElementName.endsWith("\\")) {
            replacementName = (String)replacementName + "\\";
        }
        if (document != null) {
            document.replaceString(reference.getTextRange().getStartOffset(), reference.getTextRange().getEndOffset(), (CharSequence)replacementName);
            documentManager.commitDocument(document);
        }
    }

    protected abstract PhpCaseInsensitiveProcessor getFunctionMethodProcessor();

    protected abstract PhpCaseInsensitiveProcessor getClassReferenceProcessor();

    protected abstract void visitClassReferenceInUseStatement(ClassReference var1, PsiElement var2);

    public abstract void processNamespaceReference(PhpNamespaceReference var1, String var2, String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpCaseInsensitiveVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsCaseInsensitive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceReferenceWithDelimeter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

