/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpLoopCanBeReplacedWithStrRepeatInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpConcatenationWithEmptyStringCanBeInlinedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConcatenationWithEmptyStringCanBeInlinedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                AssignmentExpression prevAssignment;
                if (expression.getOperationType() != PhpTokenTypes.opCONCAT_ASGN) {
                    return;
                }
                PsiElement parent = expression.getParent();
                if (!(parent instanceof Statement) || PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(parent.getChildren(), SelfAssignmentExpression.class) != expression) {
                    return;
                }
                Statement prevStatement = (Statement)ObjectUtils.tryCast((Object)PhpPsiUtil.getPrevSiblingIgnoreWhitespace(parent, true), Statement.class);
                AssignmentExpression assignmentExpression = prevAssignment = prevStatement != null ? PhpLoopCanBeReplacedWithStrRepeatInspection.getOnlyItem(prevStatement.getChildren(), AssignmentExpression.class) : null;
                if (prevAssignment == null || prevAssignment instanceof SelfAssignmentExpression || !PhpConcatenationWithEmptyStringCanBeInlinedInspection.isEmptyStringLiteral((PsiElement)prevAssignment.getValue())) {
                    return;
                }
                if (PhpConcatenationWithEmptyStringCanBeInlinedInspection.variablesAreTheSame(expression, prevAssignment)) {
                    return;
                }
                if (!new PhpType().add((PsiElement)expression.getValue()).global(holder.getProject()).equals(PhpType.STRING)) {
                    return;
                }
                PsiElement operation = expression.getOperation();
                if (operation == null) {
                    return;
                }
                holder.registerProblem(operation, PhpBundle.message("inspection.message.concatenation.can.be.merged.with.assignment.empty.string.literal", new Object[0]), new LocalQuickFix[]{PhpMergeWithAssignmentQuickFix.INSTANCE});
            }
        };
    }

    private static boolean variablesAreTheSame(SelfAssignmentExpression expression, AssignmentExpression assignment) {
        PhpPsiElement variable = expression.getVariable();
        if (variable == null) {
            return true;
        }
        PhpPsiElement assignedVariable = assignment.getVariable();
        return assignedVariable == null || !PhpPsiUtil.areElementsEquivalent((PsiElement)assignedVariable, (PsiElement)variable);
    }

    public static boolean isEmptyStringLiteral(PsiElement element) {
        return element instanceof StringLiteralExpression && ((StringLiteralExpression)element).getValueRange().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection", "buildVisitor"));
    }

    private static class PhpMergeWithAssignmentQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpMergeWithAssignmentQuickFix();

        private PhpMergeWithAssignmentQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.merge.with.assignment", new Object[0]);
            if (string == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            SelfAssignmentExpression element;
            PsiElement prevStatement;
            if (project == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMergeWithAssignmentQuickFix.$$$reportNull$$$0(3);
            }
            if ((prevStatement = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((element = (SelfAssignmentExpression)startElement.getParent()).getParent(), true)) == null) {
                return;
            }
            prevStatement.delete();
            String assignmentText = element.getVariable().getText() + " = " + element.getValue().getText();
            element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, assignmentText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection$PhpMergeWithAssignmentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConcatenationWithEmptyStringCanBeInlinedInspection$PhpMergeWithAssignmentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

