/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpSwitchCanBeReplacedWithMatchExpressionInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConditionCanBeReplacedWithMinMaxCallInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConditionCanBeReplacedWithMinMaxCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpIf(If ifStatement) {
                Else elseBranch = ifStatement.getElseBranch();
                if (elseBranch == null || ifStatement.getElseIfBranches().length != 0) {
                    return;
                }
                PhpExpression trueVariant = PhpConditionCanBeReplacedWithMinMaxCallInspection.extractRhsFromOnlyStatement(ifStatement.getStatement());
                PhpExpression falseVariant = PhpConditionCanBeReplacedWithMinMaxCallInspection.extractRhsFromOnlyStatement(elseBranch.getStatement());
                if (trueVariant == null || falseVariant == null || trueVariant.getClass() != falseVariant.getClass()) {
                    return;
                }
                if (trueVariant instanceof AssignmentExpression && !PhpSwitchCanBeReplacedWithMatchExpressionInspection.isHomogeneousAssignments((PsiElement)trueVariant, (PsiElement)falseVariant)) {
                    return;
                }
                PhpConditionCanBeReplacedWithMinMaxCallInspection.checkCondition(holder, ifStatement.getFirstChild(), ifStatement.getCondition(), trueVariant, falseVariant);
            }

            @Override
            public void visitPhpTernaryExpression(TernaryExpression expression) {
                PhpConditionCanBeReplacedWithMinMaxCallInspection.checkCondition(holder, (PsiElement)expression.getCondition(), expression.getCondition(), expression.getTrueVariant(), expression.getFalseVariant());
            }
        };
    }

    @Nullable
    private static PhpExpression extractRhsFromOnlyStatement(@Nullable PhpPsiElement statement) {
        Statement onlyStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)statement);
        if (onlyStatement == null) {
            return null;
        }
        if (onlyStatement instanceof PhpReturn) {
            return (PhpExpression)ObjectUtils.tryCast((Object)((PhpReturn)onlyStatement).getArgument(), PhpExpression.class);
        }
        if (onlyStatement.getFirstChild() instanceof AssignmentExpression) {
            return (PhpExpression)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureAssignment((AssignmentExpression)onlyStatement.getFirstChild()).getSecond();
        }
        return null;
    }

    private static void checkCondition(@NotNull ProblemsHolder holder, @Nullable PsiElement elementToHighlight, @Nullable PhpPsiElement condition, @Nullable PhpPsiElement trueVariant, @Nullable PhpPsiElement falseVariant) {
        if (holder == null) {
            PhpConditionCanBeReplacedWithMinMaxCallInspection.$$$reportNull$$$0(1);
        }
        if (!(condition instanceof BinaryExpression) || trueVariant == null || falseVariant == null || elementToHighlight == null) {
            return;
        }
        IElementType opType = ((BinaryExpression)condition).getOperationType();
        if (opType != PhpTokenTypes.opLESS && opType != PhpTokenTypes.opLESS_OR_EQUAL && opType != PhpTokenTypes.opGREATER && opType != PhpTokenTypes.opGREATER_OR_EQUAL) {
            return;
        }
        PsiElement leftOperand = ((BinaryExpression)condition).getLeftOperand();
        boolean leftEqFalse = PhpPsiUtil.areElementsEquivalent((PsiElement)falseVariant, leftOperand);
        if (!leftEqFalse && !PhpPsiUtil.areElementsEquivalent(leftOperand, (PsiElement)trueVariant)) {
            return;
        }
        @NotNull PhpPsiElement second = leftEqFalse ? trueVariant : falseVariant;
        PsiElement rightOperand = ((BinaryExpression)condition).getRightOperand();
        if (!PhpPsiUtil.areElementsEquivalent(rightOperand, (PsiElement)second) || PhpSideEffectDetector.canContainSideEffect(leftOperand) || PhpSideEffectDetector.canContainSideEffect(rightOperand)) {
            return;
        }
        PhpType leftOpType = new PhpType().add(leftOperand).global(condition.getProject());
        PhpType rightOpType = new PhpType().add(rightOperand).global(condition.getProject());
        if (PhpStrictTypeCheckingInspection.hasBoolean(leftOpType) && !PhpStrictTypeCheckingInspection.hasBoolean(rightOpType) || PhpStrictTypeCheckingInspection.hasBoolean(rightOpType) && !PhpStrictTypeCheckingInspection.hasBoolean(leftOpType)) {
            return;
        }
        if (leftOpType.isNullable() || rightOpType.isNullable()) {
            return;
        }
        boolean isMin = leftEqFalse ^ (opType == PhpTokenTypes.opLESS || opType == PhpTokenTypes.opLESS_OR_EQUAL);
        if (isMin) {
            holder.registerProblem(elementToHighlight, PhpBundle.message("inspection.message.can.be.replaced.with.min.max.call", "min"), new LocalQuickFix[]{PhpReplaceConditionWithMinMaxCall.REPLACE_WITH_MIN});
        } else {
            holder.registerProblem(elementToHighlight, PhpBundle.message("inspection.message.can.be.replaced.with.min.max.call", "max"), new LocalQuickFix[]{PhpReplaceConditionWithMinMaxCall.REPLACE_WITH_MAX});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "holder";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConditionCanBeReplacedWithMinMaxCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceConditionWithMinMaxCall
    extends PsiUpdateModCommandQuickFix {
        private static final PhpReplaceConditionWithMinMaxCall REPLACE_WITH_MIN = new PhpReplaceConditionWithMinMaxCall(true);
        private static final PhpReplaceConditionWithMinMaxCall REPLACE_WITH_MAX = new PhpReplaceConditionWithMinMaxCall(false);
        private final boolean myIsMin;

        private PhpReplaceConditionWithMinMaxCall(boolean isMin) {
            this.myIsMin = isMin;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.replace.with.min.max.call", this.myIsMin ? "min" : "max");
            if (string == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.min.max.call", new Object[0]);
            if (string == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            if (project == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(2);
            }
            if (psiElement == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(4);
            }
            if ((element = psiElement.getParent()) instanceof If) {
                If ifStatement = (If)element;
                this.replaceIfStatementWithMinMaxCall(project, ifStatement);
            } else if (element instanceof TernaryExpression) {
                TernaryExpression ternary = (TernaryExpression)element;
                PhpPsiElement trueVariant = ternary.getTrueVariant();
                PhpPsiElement falseVariant = ternary.getFalseVariant();
                if (trueVariant == null || falseVariant == null) {
                    return;
                }
                element.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, this.getMinMaxCall((PsiElement)ternary.getCondition())));
            }
        }

        private void replaceIfStatementWithMinMaxCall(@NotNull Project project, @NotNull If ifStatement) {
            PhpExpression trueVariant;
            if (project == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(5);
            }
            if (ifStatement == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(6);
            }
            if ((trueVariant = PhpConditionCanBeReplacedWithMinMaxCallInspection.extractRhsFromOnlyStatement(ifStatement.getStatement())) == null) {
                return;
            }
            Else elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PhpExpression falseVariant = PhpConditionCanBeReplacedWithMinMaxCallInspection.extractRhsFromOnlyStatement(elseBranch.getStatement());
            if (falseVariant == null) {
                return;
            }
            Statement onlyStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)ifStatement.getStatement());
            if (onlyStatement == null) {
                return;
            }
            PsiElement child = onlyStatement.getFirstChild();
            if (child instanceof AssignmentExpression && !(child instanceof SelfAssignmentExpression)) {
                Pair<PsiElement, PsiElement> prevAssignmentToValue = PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.getPrevAssignmentStatementToAssignedValue((PsiElement)ifStatement, ((AssignmentExpression)child).getVariable());
                if (prevAssignmentToValue.first != null) {
                    ((PsiElement)prevAssignmentToValue.first).delete();
                }
            }
            String leftHandSideText = PhpSwitchCanBeReplacedWithMatchExpressionInspection.PhpReplaceSwitchWithMatchExpressionFix.getLeftHandSideText((PsiElement)(child instanceof AssignmentExpression ? child : onlyStatement));
            String minMaxCallText = leftHandSideText + " " + this.getMinMaxCall((PsiElement)ifStatement.getCondition()) + ";";
            ifStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(project, minMaxCallText));
        }

        @NotNull
        private String getMinMaxCall(PsiElement condition) {
            assert (condition instanceof BinaryExpression);
            PsiElement leftOperand = ((BinaryExpression)condition).getLeftOperand();
            PsiElement rightOperand = ((BinaryExpression)condition).getRightOperand();
            assert (leftOperand != null && rightOperand != null);
            String string = (this.myIsMin ? "min" : "max") + "(" + leftOperand.getText() + ", " + rightOperand.getText() + ")";
            if (string == null) {
                PhpReplaceConditionWithMinMaxCall.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConditionCanBeReplacedWithMinMaxCallInspection$PhpReplaceConditionWithMinMaxCall";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpConditionCanBeReplacedWithMinMaxCallInspection$PhpReplaceConditionWithMinMaxCall";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinMaxCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceIfStatementWithMinMaxCall";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

