/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInArrayCanBeReplacedWithComparisonInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInArrayCanBeReplacedWithComparisonInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "in_array")) {
                    return;
                }
                ArrayCreationExpression haystack = (ArrayCreationExpression)ObjectUtils.tryCast((Object)PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 1), ArrayCreationExpression.class);
                if (haystack == null) {
                    return;
                }
                ImmutableList elements = ArrayCreationExpressionImpl.children(haystack).toList();
                if (elements.size() != 1) {
                    return;
                }
                Boolean strict = PhpInArrayCanBeReplacedWithComparisonInspection.isStrict(reference);
                if (strict == null) {
                    return;
                }
                PsiElement needle = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
                if (needle == null) {
                    return;
                }
                this.registerProblem(reference, PhpInArrayCanBeReplacedWithComparisonInspection.createFix(reference, needle, (PhpPsiElement)elements.get(0), strict));
            }

            private void registerProblem(@NotNull FunctionReference reference, @Nullable PhpReplaceWithComparison fix) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fix == null) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                holder.problem(nameNode.getPsi(), PhpBundle.message("inspection.message.can.be.replaced.with", fix.getTextToReplace())).fix((ModCommandAction)fix).register();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/codeSmell/PhpInArrayCanBeReplacedWithComparisonInspection$1", "registerProblem"));
            }
        };
    }

    @Nullable
    private static Boolean isStrict(FunctionReference reference) {
        PsiElement strictArgument = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 2);
        return strictArgument == null || PhpLangUtil.isFalse(strictArgument) ? Boolean.FALSE : (PhpLangUtil.isTrue(strictArgument) ? Boolean.TRUE : null);
    }

    private static PhpReplaceWithComparison createFix(FunctionReference reference, PsiElement needle, PhpPsiElement element, boolean strict) {
        Object operatorText = strict ? "===" : "==";
        PsiElement parent = reference.getParent();
        FunctionReference toReplace = reference;
        if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parent).getOperation(), PhpTokenTypes.opNOT)) {
            operatorText = "!" + ((String)operatorText).substring(1);
            toReplace = parent;
        }
        PhpPsiElement value = element instanceof ArrayHashElement ? ((ArrayHashElement)element).getValue() : element;
        return value != null ? new PhpReplaceWithComparison((PsiElement)toReplace, String.format("%s %s %s", needle.getText(), operatorText, value.getText())) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpInArrayCanBeReplacedWithComparisonInspection", "buildVisitor"));
    }

    public static class PhpReplaceWithComparison
    extends PsiUpdateModCommandAction<PsiElement> {
        @NotNull
        @NlsSafe
        private final String myTextToReplace;

        protected PhpReplaceWithComparison(@NotNull PsiElement element, @NotNull @NlsSafe String textToReplace) {
            if (element == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(0);
            }
            if (textToReplace == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(1);
            }
            super(element);
            this.myTextToReplace = textToReplace;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
            if (context == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(3);
            }
            return Presentation.of((String)PhpBundle.message("php.replace.with", this.myTextToReplace));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(6);
            }
            PsiElement replacedElement = element.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), ParenthesizedExpression.class, "(" + this.myTextToReplace + ")"));
            PhpNegateExpressionIntention.unwrapIfNecessary(replacedElement);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.comparison", new Object[0]);
            if (string == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        public String getTextToReplace() {
            String string = this.myTextToReplace;
            if (string == null) {
                PhpReplaceWithComparison.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textToReplace";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInArrayCanBeReplacedWithComparisonInspection$PhpReplaceWithComparison";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpInArrayCanBeReplacedWithComparisonInspection$PhpReplaceWithComparison";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextToReplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

