/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpConcatenationWithEmptyStringCanBeInlinedInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpLoopCanBeReplacedWithStrRepeatInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpLoopCanBeReplacedWithImplodeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeReplacedWithImplodeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                AssignmentExpression expression = PhpLoopCanBeReplacedWithStrRepeatInspection.getSingleExpression(foreach, AssignmentExpression.class);
                if (expression == null) {
                    return;
                }
                Variable foreachValue = foreach.getValue();
                if (foreachValue == null) {
                    return;
                }
                PhpPsiElement accVariable = expression.getVariable();
                if (accVariable == null) {
                    return;
                }
                PhpPsiElement concatenatedValue = null;
                if (expression instanceof SelfAssignmentExpression) {
                    if (((SelfAssignmentExpression)expression).getOperationType() != PhpTokenTypes.opCONCAT_ASGN) {
                        return;
                    }
                    concatenatedValue = expression.getValue();
                } else {
                    PhpPsiElement phpPsiElement = expression.getValue();
                    if (phpPsiElement instanceof ConcatenationExpression) {
                        ConcatenationExpression simpleConcatenation = (ConcatenationExpression)phpPsiElement;
                        PhpPsiElement leftOperand = (PhpPsiElement)ObjectUtils.tryCast((Object)simpleConcatenation.getLeftOperand(), PhpPsiElement.class);
                        if (leftOperand == null || !PhpLangUtil.equalsVariableNames(accVariable.getName(), leftOperand.getName())) {
                            return;
                        }
                        concatenatedValue = (PhpPsiElement)ObjectUtils.tryCast((Object)simpleConcatenation.getRightOperand(), PhpPsiElement.class);
                    }
                }
                if (concatenatedValue == null || !PhpLangUtil.equalsVariableNames(foreachValue.getName(), concatenatedValue.getName())) {
                    return;
                }
                AssignmentExpression prevAssignment = PhpLoopCanBeReplacedWithImplodeInspection.getPrevAssignment(accVariable, expression, (Ref<Boolean>)new Ref((Object)false));
                if (prevAssignment == null || !(prevAssignment.getValue() instanceof StringLiteralExpression)) {
                    return;
                }
                holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.message.for.loop.can.be.replaced.with.implode", new Object[0]), new LocalQuickFix[]{PhpReplaceWithImplodeCallQuickFix.INSTANCE});
            }
        };
    }

    @Nullable
    public static AssignmentExpression getPrevAssignment(PhpPsiElement variable, final AssignmentExpression anchor, final Ref<Boolean> hasReadAccesses) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return null;
        }
        final Ref prevAssignment = new Ref();
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isRead()) {
                    if (!anchor.getTextRange().contains(instruction.getAnchor().getTextRange())) {
                        hasReadAccesses.set((Object)true);
                    }
                    return true;
                }
                if (access.isWrite()) {
                    if (anchor.getTextRange().contains(instruction.getAnchor().getTextRange())) {
                        return true;
                    }
                    Variable variable = (Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class);
                    prevAssignment.set((Object)PhpPsiUtil.getParentOfClass((PsiElement)variable, AssignmentExpression.class));
                }
                return false;
            }
        });
        return (AssignmentExpression)prevAssignment.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithImplodeInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithImplodeCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceWithImplodeCallQuickFix();

        private PhpReplaceWithImplodeCallQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.implode.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithImplodeCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            ForeachStatement foreach;
            AssignmentExpression expression;
            if (project == null) {
                PhpReplaceWithImplodeCallQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithImplodeCallQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithImplodeCallQuickFix.$$$reportNull$$$0(3);
            }
            if ((expression = PhpLoopCanBeReplacedWithStrRepeatInspection.getSingleExpression(foreach = (ForeachStatement)element.getParent(), AssignmentExpression.class)) == null) {
                return;
            }
            PhpPsiElement accVariable = expression.getVariable();
            PsiElement foreachArray = foreach.getArray();
            if (accVariable == null || foreachArray == null) {
                return;
            }
            Ref leaveInitializer = new Ref((Object)false);
            AssignmentExpression assignment = PhpLoopCanBeReplacedWithImplodeInspection.getPrevAssignment(accVariable, expression, (Ref<Boolean>)leaveInitializer);
            if (assignment == null) {
                return;
            }
            if (!((Boolean)leaveInitializer.get()).booleanValue()) {
                assignment.getParent().delete();
            }
            String implodeCallText = PhpReplaceWithImplodeCallQuickFix.buildImplodeCall((PsiElement)accVariable, assignment.getValue(), foreachArray, (Boolean)leaveInitializer.get());
            AssignmentExpression implodeCall = PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, implodeCallText);
            foreach.replace(implodeCall.getParent());
        }

        private static String buildImplodeCall(PsiElement accVariable, PhpPsiElement initValue, PsiElement foreachArray, boolean hasInitializer) {
            if (hasInitializer) {
                return accVariable.getText() + ".=implode('', " + foreachArray.getText() + ");";
            }
            String implodeCall = accVariable.getText() + "=";
            if (initValue != null && !PhpConcatenationWithEmptyStringCanBeInlinedInspection.isEmptyStringLiteral((PsiElement)initValue)) {
                implodeCall = implodeCall + initValue.getText() + ".";
            }
            return implodeCall + "implode('', " + foreachArray.getText() + ");";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithImplodeInspection$PhpReplaceWithImplodeCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithImplodeInspection$PhpReplaceWithImplodeCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

