/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMatchExpressionWithOnlyDefaultArmInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpSimplifyMatchExpressionFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMatchExpressionWithOnlyDefaultArmInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                if (matchExpression.getMatchArms().isEmpty() && matchExpression.getDefaultMatchArm() != null) {
                    holder.registerProblem(matchExpression.getFirstChild(), PhpBundle.message("inspection.php.redundant.match.expression", new Object[0]), new LocalQuickFix[]{FIX});
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpMatchExpressionWithOnlyDefaultArmInspection", "buildVisitor"));
    }

    private static class PhpSimplifyMatchExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private PhpSimplifyMatchExpressionFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.simplify.expression", new Object[0]);
            if (string == null) {
                PhpSimplifyMatchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpMatchExpression matchExpression;
            if (project == null) {
                PhpSimplifyMatchExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpSimplifyMatchExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpSimplifyMatchExpressionFix.$$$reportNull$$$0(3);
            }
            if ((matchExpression = PhpPsiUtil.getParentOfClass(element, PhpMatchExpression.class)) == null) {
                return;
            }
            PhpExpression argument = matchExpression.getArgument();
            if (argument == null) {
                return;
            }
            PhpDefaultMatchArm defaultArm = matchExpression.getDefaultMatchArm();
            if (defaultArm == null || defaultArm.getBodyExpression() == null) {
                return;
            }
            if (PhpSideEffectDetector.canContainSideEffect((PsiElement)argument)) {
                Statement sideEffect = PhpPsiElementFactory.createStatement(argument.getProject(), argument.getText() + ";");
                PhpCodeEditUtil.putStatementBefore((PsiElement)matchExpression, sideEffect);
            }
            matchExpression.replace((PsiElement)defaultArm.getBodyExpression());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMatchExpressionWithOnlyDefaultArmInspection$PhpSimplifyMatchExpressionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpMatchExpressionWithOnlyDefaultArmInspection$PhpSimplifyMatchExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

