/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpNestedMinMaxCallInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNestedMinMaxCallInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                boolean isMax;
                boolean isMin = PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "min");
                boolean bl = isMax = !isMin && PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "max");
                if (isMin || isMax) {
                    PsiElement[] parameters = reference.getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        FunctionReference argumentFunctionCall = (FunctionReference)ObjectUtils.tryCast((Object)parameters[i], FunctionReference.class);
                        if (argumentFunctionCall == null || (!isMin || !PhpCodeInsightUtil.isGlobalFunctionCallWithName(argumentFunctionCall, "min")) && (!isMax || !PhpCodeInsightUtil.isGlobalFunctionCallWithName(argumentFunctionCall, "max")) || !PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.spreadArgumentsDontFollowPositional(Arrays.asList(parameters), i, Arrays.asList(argumentFunctionCall.getParameters())) || PhpNestedMinMaxCallInspection.hasNonLiteralArrayParam(argumentFunctionCall)) continue;
                        holder.registerProblem((PsiElement)argumentFunctionCall, PhpBundle.message("inspection.message.nested.call.can.be.unwrapped", reference.getName()), new LocalQuickFix[]{PhpUnwrapFunctionCallQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    private static boolean hasNonLiteralArrayParam(FunctionReference functionReference) {
        return ContainerUtil.exists((Object[])functionReference.getParameters(), p -> {
            if (p instanceof ArrayCreationExpression) {
                return false;
            }
            PhpType type = PhpType.global(p);
            return PhpType.isArray(type) || type.isAmbiguous();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedMinMaxCallInspection", "buildVisitor"));
    }

    private static class PhpUnwrapFunctionCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapFunctionCallQuickFix();

        private PhpUnwrapFunctionCallQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.call", new Object[0]);
            if (string == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference nestedCall;
            ParameterList parameterList;
            if (project == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(3);
            }
            if ((parameterList = (nestedCall = (FunctionReference)element).getParameterList()) == null) {
                return;
            }
            ParameterList parentParameterList = (ParameterList)nestedCall.getParent();
            String newParentParameterListText = nestedCall.getTextRangeInParent().replace(parentParameterList.getText(), PhpUnwrapFunctionCallQuickFix.unwrapArrayLiteral(parameterList));
            parentParameterList.replace((PsiElement)PhpPsiElementFactory.createArgumentList(project, newParentParameterListText));
        }

        private static String unwrapArrayLiteral(ParameterList parameterList) {
            PsiElement[] parameters = parameterList.getParameters();
            if (parameters.length == 1 && parameters[0] instanceof ArrayCreationExpressionImpl) {
                return ((ArrayCreationExpressionImpl)parameters[0]).values().map(PsiElement::getText).collect(Collectors.joining(","));
            }
            return parameterList.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedMinMaxCallInspection$PhpUnwrapFunctionCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpNestedMinMaxCallInspection$PhpUnwrapFunctionCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

