/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUnusedParameterInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysNullInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParameterByRefIsNotUsedAsReferenceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                PhpParameterByRefIsNotUsedAsReferenceInspection.doCheck(function, holder, PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(function));
            }

            @Override
            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod) {
                    return;
                }
                MultiMap parametersByRefNames = ContainerUtil.groupBy(PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(method), Parameter::getName);
                PhpParameterByRefIsNotUsedAsReferenceInspection.removeParametersByRefInHierarchy(method, (MultiMap<CharSequence, Parameter>)parametersByRefNames);
                PhpParameterByRefIsNotUsedAsReferenceInspection.doCheck(method, holder, parametersByRefNames.values());
            }

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                Object bitAnd;
                Variable value = foreach.getValue();
                if (value != null && PhpCodeInsightUtil.getAccess(value).isWriteRef() && PhpParameterByRefIsNotUsedAsReferenceInspection.isForeachValuePassByRefIsNotUsed(foreach, value) && (bitAnd = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)value, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opBIT_AND)))) != null) {
                    PhpParameterByRefIsNotUsedAsReferenceInspection.registerProblem(holder, bitAnd);
                }
            }
        };
    }

    private static boolean isForeachValuePassByRefIsNotUsed(@NotNull ForeachStatement foreach, Variable value) {
        PhpAccessVariableInstruction instruction;
        if (foreach == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(1);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction(value, PhpAccessVariableInstruction.class)) == null || !PhpParameterByRefIsNotUsedAsReferenceInspection.isUnusedAsRefParameter(instruction, value).booleanValue()) {
            return false;
        }
        PsiElement array = foreach.getArray();
        if (array instanceof Variable) {
            return PhpParameterByRefIsNotUsedAsReferenceInspection.checkArrayChangesInsideForeach(foreach, instruction, array);
        }
        return true;
    }

    private static boolean checkArrayChangesInsideForeach(final @NotNull ForeachStatement foreach, PhpAccessVariableInstruction instruction, PsiElement array) {
        if (foreach == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(2);
        }
        Ref res = new Ref((Object)true);
        final PhpInstructionProcessor processor = PhpParameterByRefIsNotUsedAsReferenceInspection.createProcessorToRemoveUsedRefDeclarations((Variable)array, (Ref<Boolean>)res);
        PhpParameterByRefIsNotUsedAsReferenceInspection.processSuccessorsIgnoringInitialBackEdge(instruction, new PhpInstructionProcessor(){

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                PsiElement anchor = instruction.getAnchor();
                if (anchor != null && !PsiTreeUtil.isAncestor((PsiElement)foreach, (PsiElement)anchor, (boolean)false)) {
                    return false;
                }
                return instruction.process(processor);
            }
        });
        return (Boolean)res.get();
    }

    private static void processSuccessorsIgnoringInitialBackEdge(PhpAccessVariableInstruction instruction, PhpInstructionProcessor declarations) {
        BitSet visitedSetWithoutInitialEdge = new BitSet();
        visitedSetWithoutInitialEdge.set(instruction.num());
        PhpControlFlowUtil.processSuccessors(instruction, false, declarations, visitedSetWithoutInitialEdge);
    }

    private static void removeParametersByRefInHierarchy(Method method, MultiMap<CharSequence, Parameter> parametersByRefNames) {
        if (parametersByRefNames.isEmpty()) {
            return;
        }
        PhpClassHierarchyUtils.processSuperMethods(method, (member, subClass, baseClass) -> {
            for (Parameter parameter : PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(member)) {
                parametersByRefNames.remove((Object)parameter.getName());
            }
            return false;
        });
        if (parametersByRefNames.isEmpty()) {
            return;
        }
        PhpClassHierarchyUtils.processOverridingMethods(method, (member, subClass, baseClass) -> {
            for (Parameter parameter : PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(member)) {
                parametersByRefNames.remove((Object)parameter.getName());
            }
            return false;
        });
    }

    private static void doCheck(Function function, @NotNull ProblemsHolder holder, Collection<Parameter> elementsByRef) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(3);
        }
        for (Parameter parameter : elementsByRef) {
            PsiElement bitAnd;
            if (!PhpParameterByRefIsNotUsedAsReferenceInspection.isUnusedAsRefParameter(function, parameter) || (bitAnd = PhpPsiUtil.getChildOfType((PsiElement)parameter, PhpTokenTypes.opBIT_AND)) == null) continue;
            PhpParameterByRefIsNotUsedAsReferenceInspection.registerProblem(holder, bitAnd);
        }
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, PsiElement bitAnd) {
        if (holder == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(4);
        }
        holder.problem(bitAnd, PhpBundle.message("pass.by.ref.is.not.effectively.used.inside.body", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(bitAnd, PhpBundle.message("remove.pass.by.ref", new Object[0]))).register();
    }

    public static boolean isUnusedAsRefParameter(Function function, Parameter parameter) {
        if (parameter instanceof PhpPromotedFieldParameterImpl) {
            return false;
        }
        PhpControlFlow flow = function.getControlFlow();
        if (flow.getInstructions().length == 0) {
            return false;
        }
        return PhpParameterByRefIsNotUsedAsReferenceInspection.isUnusedAsRefParameter(flow.getEntryPoint(), (PhpNamedElement)parameter);
    }

    private static Boolean isUnusedAsRefParameter(@NotNull PhpInstruction point, PhpNamedElement parameter) {
        if (point == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(5);
        }
        Ref unusedAsRefParameter = new Ref((Object)true);
        PhpControlFlowUtil.processSuccessors(point, false, PhpParameterByRefIsNotUsedAsReferenceInspection.createProcessorToRemoveUsedRefDeclarations(parameter, (Ref<Boolean>)unusedAsRefParameter));
        return (Boolean)unusedAsRefParameter.get();
    }

    @NotNull
    private static PhpInstructionProcessor createProcessorToRemoveUsedRefDeclarations(final PhpNamedElement parameter, final Ref<Boolean> unusedAsRefParameter) {
        final String parameterName = parameter.getName();
        return new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Variable iteratedArray;
                PhpPsiElement anchor;
                ForeachStatement foreachStatement;
                CharSequence name = instruction.getVariableName();
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access.isWriteRef() && (foreachStatement = (ForeachStatement)ObjectUtils.tryCast((Object)(anchor = instruction.getAnchor()).getParent(), ForeachStatement.class)) != null && foreachStatement.getValue() == anchor && (iteratedArray = PhpParameterByRefIsNotUsedAsReferenceInspection.getBaseIteratedArray(foreachStatement)) != null && iteratedArray.resolveLocal().contains(parameter)) {
                    unusedAsRefParameter.set((Object)false);
                    return false;
                }
                if (PhpLangUtil.equalsVariableNames(parameterName, name)) {
                    if (access.isUnset() || access.isWriteRef()) {
                        return false;
                    }
                    if (PhpParameterByRefIsNotUsedAsReferenceInspection.mayBeRefAccess(instruction)) {
                        unusedAsRefParameter.set((Object)false);
                        return false;
                    }
                }
                return (Boolean)unusedAsRefParameter.get();
            }

            @Override
            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (PhpLangUtil.equalsVariableNames(name, parameterName) && (PhpParameterByRefIsNotUsedAsReferenceInspection.mayBeRefAccess(instruction) || access.isUnset())) {
                    unusedAsRefParameter.set((Object)false);
                }
                return (Boolean)unusedAsRefParameter.get();
            }
        };
    }

    @Nullable
    private static Variable getBaseIteratedArray(ForeachStatement foreachStatement) {
        Object array = foreachStatement.getArray();
        while (array instanceof ArrayAccessExpression) {
            array = ((ArrayAccessExpression)array).getValue();
        }
        return (Variable)ObjectUtils.tryCast((Object)array, Variable.class);
    }

    private static boolean parameterOfUnresolvedCall(PhpAccessInstruction instruction) {
        if (((PhpAccessInstructionImpl)instruction).isReadOrReadRefAccessLocalAware()) {
            FunctionReference functionReference = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), FunctionReference.class);
            return functionReference != null && (functionReference.getName() == null || functionReference.multiResolve(false).length == 0);
        }
        return false;
    }

    private static Collection<Parameter> getParametersByRefNames(Function function) {
        if (!function.hasRefParams()) {
            return Collections.emptyList();
        }
        Int2ObjectMap<PhpUnusedParameterInspection.ParameterNotUsedReason> unusedParameters = PhpUnusedParameterInspection.getUnusedParameters(function.getParameters(), function, false);
        return PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(function.getParameters(), unusedParameters.keySet().toIntArray());
    }

    @NotNull
    public static Collection<Parameter> getParametersByRefNames(Parameter[] parameters, int[] keys) {
        Collection collection = IntStream.range(0, parameters.length).filter(i -> ArrayUtil.indexOf((int[])keys, (int)i) < 0).mapToObj(i -> parameters[i]).filter(Parameter::isPassByRef).collect(Collectors.toList());
        if (collection == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static boolean mayBeRefAccess(@NotNull PhpAccessInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (instruction == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(7);
        }
        return (access = instruction.getAccess()).isWriteRef() || access.isReadRef() || access.isWrite() || PhpParameterByRefIsNotUsedAsReferenceInspection.parameterOfUnresolvedCall(instruction) || PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)instruction.getAnchor());
    }

    public static boolean isReturnedFromReturnByRefFunction(@NotNull PsiElement element) {
        PhpReturn phpReturn;
        if (element == null) {
            PhpParameterByRefIsNotUsedAsReferenceInspection.$$$reportNull$$$0(8);
        }
        return (phpReturn = PhpPsiUtil.getParentOfClass(element, PhpReturn.class)) != null && PhpPsiUtil.unparenthesize(phpReturn.getArgument()) == element && PhpExpressionAlwaysNullInspection.insideReturnByReferenceFunction(phpReturn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpParameterByRefIsNotUsedAsReferenceInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpParameterByRefIsNotUsedAsReferenceInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersByRefNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isForeachValuePassByRefIsNotUsed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayChangesInsideForeach";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedAsRefParameter";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayBeRefAccess";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReturnedFromReturnByRefFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

