/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPregMatchWithoutEffectiveRegexpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StringLiteralExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPregReplaceWithEmptyReplacementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_replace")) {
                    return;
                }
                PsiElement[] params = reference.getParameters();
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || params.length != 3) {
                    return;
                }
                StringLiteralExpression replacement = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameterList.getParameter("replacement", 1), StringLiteralExpression.class);
                if (replacement == null || !replacement.getContents().isEmpty()) {
                    return;
                }
                StringLiteralExpressionImpl pattern = (StringLiteralExpressionImpl)ObjectUtils.tryCast((Object)parameterList.getParameter("pattern", 0), StringLiteralExpressionImpl.class);
                if (pattern == null) {
                    return;
                }
                String options = pattern.getRegExpOptionsText();
                if (options == null || !options.isEmpty()) {
                    return;
                }
                RegExpBranch[] branches = PhpPregReplaceWithEmptyReplacementInspection.getBranches(pattern);
                if (branches == null || branches.length > 2) {
                    return;
                }
                PhpTrimFunctionDescriptor phpTrimFunctionDescriptor = PhpPregReplaceWithEmptyReplacementInspection.getPhpTrimFunctionDescriptor(branches);
                if (phpTrimFunctionDescriptor == null) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.can.be.replaced.with.str.function", phpTrimFunctionDescriptor.getFunctionName()), new LocalQuickFix[]{new PhpReplacePregReplaceFunctionCallQuickFix(phpTrimFunctionDescriptor)});
            }
        };
    }

    private static RegExpBranch[] getBranches(@NotNull StringLiteralExpression pattern) {
        RegExpFile injectedRegexpFile;
        if (pattern == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.getChildByCondition((PsiElement)pattern, Variable.INSTANCEOF) != null) {
            return null;
        }
        Pair injectionInfo = (Pair)ContainerUtil.getOnlyItem((Collection)InjectedLanguageManager.getInstance((Project)pattern.getProject()).getInjectedPsiFiles((PsiElement)pattern));
        RegExpFile regExpFile = injectedRegexpFile = injectionInfo != null ? (RegExpFile)ObjectUtils.tryCast((Object)injectionInfo.getFirst(), RegExpFile.class) : null;
        if (injectedRegexpFile == null) {
            return null;
        }
        RegExpPattern child = PhpPregMatchWithoutEffectiveRegexpInspection.getOnlyChildOfType((PsiElement)injectedRegexpFile, RegExpPattern.class);
        if (child == null) {
            return null;
        }
        return child.getBranches();
    }

    @Nullable
    private static PhpTrimFunctionDescriptor getPhpTrimFunctionDescriptor(RegExpBranch[] branches) {
        if (branches.length == 1) {
            return PhpPregReplaceWithEmptyReplacementInspection.getLeftOrRightTrimFunction(branches[0]);
        }
        if (branches.length == 2) {
            PhpTrimFunctionDescriptor trimFromLeftBranch = PhpPregReplaceWithEmptyReplacementInspection.getLeftOrRightTrimFunction(branches[0]);
            PhpTrimFunctionDescriptor trimFromRightBranch = PhpPregReplaceWithEmptyReplacementInspection.getLeftOrRightTrimFunction(branches[1]);
            if (trimFromLeftBranch == null || trimFromRightBranch == null) {
                return null;
            }
            return PhpPregReplaceWithEmptyReplacementInspection.composeTrimFunction(trimFromLeftBranch, trimFromRightBranch);
        }
        return null;
    }

    @Nullable
    private static PhpTrimFunctionDescriptor composeTrimFunction(@NotNull PhpTrimFunctionDescriptor trimFromLeftBranch, @NotNull PhpTrimFunctionDescriptor trimFromRightBranch) {
        Set<String> rightBranchCharsToTrim;
        Set<String> leftBranchCharsToTrim;
        if (trimFromLeftBranch == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(2);
        }
        if (trimFromRightBranch == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(3);
        }
        String leftBranchFunctionName = trimFromLeftBranch.getFunctionName();
        String rightBranchFunctionName = trimFromRightBranch.getFunctionName();
        if ((leftBranchFunctionName.equals("ltrim") && rightBranchFunctionName.equals("rtrim") || leftBranchFunctionName.equals("rtrim") && rightBranchFunctionName.equals("ltrim")) && (leftBranchCharsToTrim = trimFromLeftBranch.getCharsToTrim()).containsAll(rightBranchCharsToTrim = trimFromRightBranch.getCharsToTrim()) && rightBranchCharsToTrim.containsAll(leftBranchCharsToTrim)) {
            return new PhpTrimFunctionDescriptor("trim", rightBranchCharsToTrim);
        }
        return null;
    }

    @Nullable
    private static PhpTrimFunctionDescriptor getLeftOrRightTrimFunction(@NotNull RegExpBranch branch) {
        RegExpAtom[] atoms;
        if (branch == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(4);
        }
        if ((atoms = branch.getAtoms()).length == 2) {
            if (PhpPregMatchWithoutEffectiveRegexpInspection.isLineStart(atoms[0])) {
                Set<String> charsToTrim = PhpPregReplaceWithEmptyReplacementInspection.getCharsToTrim(atoms[1]);
                if (charsToTrim == null) {
                    return null;
                }
                return new PhpTrimFunctionDescriptor("ltrim", charsToTrim);
            }
            if (PhpPregMatchWithoutEffectiveRegexpInspection.isLineEnd(atoms[1])) {
                Set<String> charsToTrim = PhpPregReplaceWithEmptyReplacementInspection.getCharsToTrim(atoms[0]);
                if (charsToTrim == null) {
                    return null;
                }
                return new PhpTrimFunctionDescriptor("rtrim", charsToTrim);
            }
        }
        return null;
    }

    @Nullable
    private static Set<String> getCharsToTrim(@NotNull RegExpAtom atom) {
        RegExpSimpleClass.Kind kind;
        RegExpClosure closure;
        if (atom == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(5);
        }
        if ((closure = (RegExpClosure)ObjectUtils.tryCast((Object)atom, RegExpClosure.class)) == null) {
            return null;
        }
        IElementType type = closure.getQuantifier().getFirstChild().getNode().getElementType();
        if (type != RegExpTT.STAR && type != RegExpTT.PLUS) {
            return null;
        }
        RegExpSimpleClass regExpSimpleClass = (RegExpSimpleClass)ObjectUtils.tryCast((Object)closure.getAtom(), RegExpSimpleClass.class);
        if (regExpSimpleClass != null && (kind = regExpSimpleClass.getKind()) == RegExpSimpleClass.Kind.SPACE) {
            return new HashSet<String>();
        }
        RegExpClass regExpClass = (RegExpClass)ObjectUtils.tryCast((Object)closure.getAtom(), RegExpClass.class);
        if (regExpClass != null && !regExpClass.isNegated()) {
            HashSet<String> charsToTrim = new HashSet<String>();
            for (RegExpClassElement classElement : regExpClass.getElements()) {
                String charToTrim = PhpPregReplaceWithEmptyReplacementInspection.getCharToTrim((RegExpElement)classElement);
                if (charToTrim == null) {
                    return null;
                }
                charsToTrim.add(charToTrim);
            }
            return charsToTrim;
        }
        String charToTrim = PhpPregReplaceWithEmptyReplacementInspection.getCharToTrim((RegExpElement)closure.getAtom());
        if (charToTrim == null) {
            return null;
        }
        return Collections.singleton(charToTrim);
    }

    @Nullable
    private static String getCharToTrim(@NotNull RegExpElement element) {
        RegExpChar regExpChar;
        int charValue;
        if (element == null) {
            PhpPregReplaceWithEmptyReplacementInspection.$$$reportNull$$$0(6);
        }
        int n = charValue = (regExpChar = (RegExpChar)ObjectUtils.tryCast((Object)element, RegExpChar.class)) == null ? -1 : regExpChar.getValue();
        if (charValue == -1) {
            return null;
        }
        IElementType type = regExpChar.getFirstChild().getNode().getElementType();
        if (type.equals(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) || type.equals(RegExpTT.NAMED_CHARACTER) || type.equals(RegExpTT.REDUNDANT_ESCAPE) || type.equals(RegExpTT.CTRL)) {
            return null;
        }
        if (type.equals(RegExpTT.ESC_CHARACTER)) {
            return Character.toString((char)charValue);
        }
        if (type.equals(RegExpTT.ESC_CTRL_CHARACTER) || type.equals(RegExpTT.CTRL_CHARACTER)) {
            return PhpTrimFunctionDescriptor.ESC_CTRL_CHARS.get(charValue);
        }
        return regExpChar.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimFromLeftBranch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimFromRightBranch";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atom";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregReplaceWithEmptyReplacementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBranches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "composeTrimFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeftOrRightTrimFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharsToTrim";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharToTrim";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpTrimFunctionDescriptor {
        @NotNull
        private final String myFunctionName;
        @NotNull
        private final Set<String> myCharsToTrim;
        private final boolean myTrimDefaultChars;
        private static final Map<Integer, String> ESC_CTRL_CHARS = Map.of(10, "\\n", 13, "\\r", 9, "\\t", 12, "\\f", 8, "\\b", 7, "\\u{0007}", 27, "\\u{001b}");

        private PhpTrimFunctionDescriptor(@NotNull String functionName, @NotNull Set<String> charsToTrim) {
            if (functionName == null) {
                PhpTrimFunctionDescriptor.$$$reportNull$$$0(0);
            }
            if (charsToTrim == null) {
                PhpTrimFunctionDescriptor.$$$reportNull$$$0(1);
            }
            this.myFunctionName = functionName;
            this.myCharsToTrim = charsToTrim;
            this.myTrimDefaultChars = charsToTrim.isEmpty();
        }

        @NotNull
        private String getFunctionName() {
            String string = this.myFunctionName;
            if (string == null) {
                PhpTrimFunctionDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private Set<String> getCharsToTrim() {
            Set<String> set = this.myCharsToTrim;
            if (set == null) {
                PhpTrimFunctionDescriptor.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charsToTrim";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregReplaceWithEmptyReplacementInspection$PhpTrimFunctionDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregReplaceWithEmptyReplacementInspection$PhpTrimFunctionDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharsToTrim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpReplacePregReplaceFunctionCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final PhpTrimFunctionDescriptor myTrimFunctionDescriptor;

        private PhpReplacePregReplaceFunctionCallQuickFix(PhpTrimFunctionDescriptor trimFunctionDescriptor) {
            this.myTrimFunctionDescriptor = trimFunctionDescriptor;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.str.function.call", this.myTrimFunctionDescriptor.getFunctionName());
            if (string == null) {
                PhpReplacePregReplaceFunctionCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private String getCharsToTrim() {
            StringBuilder charsToTrim = new StringBuilder();
            for (String charToTrim : this.myTrimFunctionDescriptor.getCharsToTrim()) {
                charsToTrim.append(charToTrim);
            }
            return charsToTrim.toString();
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference reference;
            if (project == null) {
                PhpReplacePregReplaceFunctionCallQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplacePregReplaceFunctionCallQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplacePregReplaceFunctionCallQuickFix.$$$reportNull$$$0(3);
            }
            if ((reference = (FunctionReference)ObjectUtils.tryCast((Object)element, FunctionReference.class)) == null) {
                return;
            }
            ParameterList parameterList = reference.getParameterList();
            if (parameterList == null) {
                return;
            }
            PsiElement subject = parameterList.getParameter("subject", 2);
            if (subject == null) {
                return;
            }
            String charsToTrim = this.getCharsToTrim();
            String subjectText = subject.getText();
            String trimFunctionText = this.myTrimFunctionDescriptor.myTrimDefaultChars ? String.format("%s(%s)", this.myTrimFunctionDescriptor.getFunctionName(), subjectText) : String.format("%s(%s, %s)", this.myTrimFunctionDescriptor.getFunctionName(), subjectText, "\"" + charsToTrim + "\"");
            FunctionReference trimFunction = PhpPsiElementFactory.createFunctionReference(reference.getProject(), trimFunctionText);
            reference.replace((PsiElement)trimFunction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregReplaceWithEmptyReplacementInspection$PhpReplacePregReplaceFunctionCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregReplaceWithEmptyReplacementInspection$PhpReplacePregReplaceFunctionCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

