/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRedundantArrayCallInForeachIteratedValueInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantArrayCallInForeachIteratedValueInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                FunctionReference ref;
                PsiElement array = foreach.getArray();
                if (foreach.getKey() != null) {
                    return;
                }
                if (array instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName(ref = (FunctionReference)array, "array_values")) {
                    holder.problem(array, PhpBundle.message("inspection.message.array.values.call.redundant", new Object[0])).fix((ModCommandAction)new PhpReplaceWithValueQuickFix(ref)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantArrayCallInForeachIteratedValueInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithValueQuickFix
    extends PsiUpdateModCommandAction<FunctionReference> {
        private PhpReplaceWithValueQuickFix(FunctionReference array) {
            super((PsiElement)array);
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull FunctionReference ref) {
            PsiElement argument;
            if (context == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(0);
            }
            if (ref == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(1);
            }
            if ((argument = ref.getParameter(0)) != null) {
                return Presentation.of((String)PhpBundle.message("intention.family.name.replace.with", argument.getText()));
            }
            return Presentation.of((String)this.getFamilyName());
        }

        protected void invoke(@NotNull ActionContext context, @NotNull FunctionReference functionReference, @NotNull ModPsiUpdater updater) {
            PsiElement argument;
            if (context == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(2);
            }
            if (functionReference == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(4);
            }
            if ((argument = functionReference.getParameter(0)) != null) {
                functionReference.replace(argument);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.argument", new Object[0]);
            if (string == null) {
                PhpReplaceWithValueQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantArrayCallInForeachIteratedValueInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantArrayCallInForeachIteratedValueInspection$PhpReplaceWithValueQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

