/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.navigation.PhpGotoBreakContinueHandler;
import org.jetbrains.annotations.NotNull;

public final class PhpRedundantDefaultBreakContinueArgumentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantDefaultBreakContinueArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpBreak(PhpBreak breakStatement) {
                this.doCheck(breakStatement);
            }

            @Override
            public void visitPhpContinue(PhpContinue continueStatement) {
                this.doCheck(continueStatement);
            }

            private void doCheck(StatementWithArgument statement) {
                PsiElement argument = statement.getArgument();
                if (argument != null && PhpGotoBreakContinueHandler.Companion.getArgument(statement) == 1) {
                    holder.problem(argument, PhpBundle.message("inspection.message.redundant.expression", new Object[0])).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(argument)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpRedundantDefaultBreakContinueArgumentInspection", "buildVisitor"));
    }
}

