/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.expectedArguments.PhpExpectedFunctionArgumentLookupElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpUnusedParameterInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPrivateMethodsUsagesProcessInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveParametersQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableHandler;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSameParameterValueInspection
extends PhpPrivateMethodsUsagesProcessInspectionBase<Parameter, PsiElement> {
    private static final Set<String> DYNAMIC_SEMANTIC_CONSTANTS = Set.of("\\__FILE__", "\\__LINE__", "\\__CLASS__", "\\__FUNCTION__", "\\__METHOD__", "\\__TRAIT__", "\\__DIR__", "\\__NAMESPACE__");

    @Override
    protected boolean isMethodSuitable(Method method) {
        return method.getParameters().length > 0;
    }

    @Override
    protected void putValuesFromPrivateMethodCalls(MultiMap<Parameter, PsiElement> values, @NotNull PhpReference reference, Method resolvedMethod, List<PsiElement> arguments) {
        if (reference == null) {
            PhpSameParameterValueInspection.$$$reportNull$$$0(0);
        }
        if (arguments.isEmpty()) {
            return;
        }
        List<Parameter> parameters = Arrays.asList(resolvedMethod.getParameters());
        if (parameters.isEmpty()) {
            return;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            PsiElement argument = arguments.get(i);
            if (PhpCodeInsightUtil.isUnpackedArgument(argument)) {
                for (int j = i; j < parameters.size(); ++j) {
                    values.putValue((Object)parameters.get(j), (Object)argument);
                }
                continue;
            }
            Parameter resolvedParameter = PhpParamsInspection.getMappedParam(arguments, parameters, i);
            if (resolvedParameter == null) continue;
            values.putValue((Object)resolvedParameter, (Object)argument);
        }
    }

    @Override
    protected MultiMap<Parameter, PsiElement> createInitialMap(PhpClass clazz, Collection<Method> candidatePrivateMethods) {
        return new MultiMap<Parameter, PsiElement>(){

            @NotNull
            protected Collection<PsiElement> createCollection() {
                return new ObjectOpenCustomHashSet((Hash.Strategy)MySamePhpElementsToInlineStrategy.INSTANCE);
            }
        };
    }

    @Override
    protected void processAllValuesFromMethodCalls(MultiMap<Parameter, PsiElement> argumentValues, Collection<Method> candidatePrivateMethods, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            PhpSameParameterValueInspection.$$$reportNull$$$0(1);
        }
        Set parameters = candidatePrivateMethods.stream().flatMap(m -> Arrays.stream(m.getParameters())).collect(Collectors.toSet());
        for (Parameter parameter : parameters) {
            PsiElement value = parameter.getDefaultValue();
            if (value == null) continue;
            argumentValues.putValue((Object)parameter, (Object)value);
        }
        for (Parameter parameter : argumentValues.keySet()) {
            PsiElement actualArgumentValue = (PsiElement)ContainerUtil.getOnlyItem((Collection)argumentValues.get((Object)parameter));
            if (actualArgumentValue == null || !PhpSameParameterValueInspection.canBeInlined(actualArgumentValue) || !parameters.contains(parameter) || PhpSameParameterValueInspection.isDynamicSemantic(actualArgumentValue)) continue;
            holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)parameter.getNameIdentifier(), (Object)parameter), PhpBundle.message("inspection.message.value.parameter.always", actualArgumentValue.getText()), new LocalQuickFix[]{new PhpInlineValueQuickFix(parameter, actualArgumentValue)});
        }
    }

    private static boolean isDynamicSemantic(PsiElement value) {
        return value instanceof ConstantReference && ContainerUtil.exists((Iterable)((ConstantReference)value).multiResolveStrict(Constant.class), c -> DYNAMIC_SEMANTIC_CONSTANTS.contains(c.getFQN()));
    }

    private static boolean canBeInlined(@Nullable PsiElement element) {
        if (element != null && PhpCodeInsightUtil.isUnpackedArgument(element)) {
            return false;
        }
        if (PhpLangUtil.isNull(element)) {
            return true;
        }
        if (element instanceof Variable) {
            return false;
        }
        if (element instanceof StringLiteralExpression) {
            return PhpPsiUtil.getChildByCondition(element, Variable.INSTANCEOF) == null;
        }
        if (element instanceof ArrayCreationExpression) {
            return PhpSameParameterValueInspection.arrayChildren((ArrayCreationExpression)element).allMatch(PhpSameParameterValueInspection::canBeInlined);
        }
        return PhpExpectedFunctionArgumentLookupElement.ELEMENT_CAN_BE_EXPECTED_ARGUMENT.value((Object)element);
    }

    private static @NotNull Stream<@Nullable PhpPsiElement> arrayChildren(ArrayCreationExpression element) {
        Stream<PhpPsiElement> stream = ArrayCreationExpressionImpl.children(element).stream().flatMap(e -> e instanceof ArrayHashElement ? Stream.of(((ArrayHashElement)e).getKey(), ((ArrayHashElement)e).getValue()) : Stream.of(e.getFirstPsiChild()));
        if (stream == null) {
            PhpSameParameterValueInspection.$$$reportNull$$$0(2);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putValuesFromPrivateMethodCalls";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAllValuesFromMethodCalls";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpInlineValueQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpInlineValueQuickFix(Parameter parameter, PsiElement valueToInline) {
            super((PsiElement)parameter, valueToInline);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.inline.value.for.parameter", new Object[0]);
            if (string == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            PsiElement element = this.getEndElement();
            String string = element != null ? PhpBundle.message("intention.name.inline.value", StringUtil.first((String)element.getText(), (int)30, (boolean)true)) : this.getFamilyName();
            if (string == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement valueToInline) {
            if (project == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(4);
            }
            if (valueToInline == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(5);
            }
            int index = PhpCodeInsightUtil.getParameterIndex(startElement);
            Method method = PhpPsiUtil.getParentOfClass(startElement, Method.class);
            if (method == null) {
                return;
            }
            GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition(method, GroupStatement.INSTANCEOF);
            if (body == null) {
                return;
            }
            if (!IntentionPreviewUtils.isPreviewElement((PsiElement)file) && !FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Object[] parameters = method.getParameters();
            boolean unusedParameter = PhpUnusedParameterInspection.getUnusedParameters((Parameter[])parameters, method, true).containsKey(ArrayUtil.indexOfIdentity((Object[])parameters, (Object)startElement));
            if (!unusedParameter) {
                method = PhpInlineValueQuickFix.inlineParameterValue(project, (Parameter)startElement, valueToInline, body);
            }
            assert (method != null);
            PhpRemoveParametersQuickFix.removeParameters(method, Collections.singleton(method.getParameters()[index]));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(6);
            }
            if (previewDescriptor == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(7);
            }
            PsiFile copy = previewDescriptor.getPsiElement().getContainingFile();
            this.invoke(project, copy, PsiTreeUtil.findSameElementInCopy((PsiElement)this.getStartElement(), (PsiFile)copy), PsiTreeUtil.findSameElementInCopy((PsiElement)this.getEndElement(), (PsiFile)copy));
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }

        @Nullable
        private static Method inlineParameterValue(@NotNull Project project, Parameter startElement, @NotNull PsiElement valueToInline, GroupStatement body) {
            if (project == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(9);
            }
            if (valueToInline == null) {
                PhpInlineValueQuickFix.$$$reportNull$$$0(10);
            }
            try {
                return (Method)IntentionPreviewUtils.writeAndCompute(() -> {
                    String assignmentText = "$" + startElement.getName() + " = " + valueToInline.getText() + ";";
                    PsiElement assignment = body.addAfter(PhpPsiElementFactory.createPhpPsiFromText(project, AssignmentExpression.class, assignmentText).getParent(), body.getFirstChild());
                    Method updatedMethod = PhpPsiUtil.getParentOfClass(assignment, Method.class);
                    if (!(valueToInline instanceof ArrayCreationExpression)) {
                        PhpPsiElement introducedVariable = ((AssignmentExpression)assignment.getFirstChild()).getVariable();
                        PhpInlineVariableHandler.invoke(project, null, (Variable)introducedVariable);
                    }
                    return updatedMethod;
                });
            }
            catch (PhpRefactoringErrorException e) {
                return null;
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection$PhpInlineValueQuickFix";
                    break;
                }
                case 2: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueToInline";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection$PhpInlineValueQuickFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "inlineParameterValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MySamePhpElementsToInlineStrategy
    implements Hash.Strategy<PsiElement> {
        private static final MySamePhpElementsToInlineStrategy INSTANCE = new MySamePhpElementsToInlineStrategy();

        private MySamePhpElementsToInlineStrategy() {
        }

        @NotNull
        private static String getValue(@NotNull PsiElement element) {
            if (element == null) {
                MySamePhpElementsToInlineStrategy.$$$reportNull$$$0(0);
            }
            if (element instanceof ArrayCreationExpression) {
                String string = PhpSameParameterValueInspection.arrayChildren((ArrayCreationExpression)element).filter(Objects::nonNull).map(MySamePhpElementsToInlineStrategy::getValue).collect(Collectors.joining("|"));
                if (string == null) {
                    MySamePhpElementsToInlineStrategy.$$$reportNull$$$0(1);
                }
                return string;
            }
            if (element instanceof PhpReference) {
                String resolvedSignature = Arrays.stream(((PhpReference)element).multiResolve(false)).map(e -> (PhpNamedElement)ObjectUtils.tryCast((Object)e.getElement(), PhpNamedElement.class)).filter(Objects::nonNull).map(PhpNamedElement::getFQN).collect(Collectors.joining("|"));
                String string = resolvedSignature.isEmpty() ? ((PhpReference)element).getSignature() : resolvedSignature;
                if (string == null) {
                    MySamePhpElementsToInlineStrategy.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = element.getText();
            if (string == null) {
                MySamePhpElementsToInlineStrategy.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int hashCode(PsiElement object) {
            return object == null ? 0 : MySamePhpElementsToInlineStrategy.getValue(object).hashCode();
        }

        public boolean equals(PsiElement o1, PsiElement o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return MySamePhpElementsToInlineStrategy.getValue(o1).equals(MySamePhpElementsToInlineStrategy.getValue(o2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection$MySamePhpElementsToInlineStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpSameParameterValueInspection$MySamePhpElementsToInlineStrategy";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

