/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpTernaryExpressionCanBeReducedToShortVersionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTernaryExpressionCanBeReducedToShortVersionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpTernaryExpression(TernaryExpression expression) {
                if (expression.isShort()) {
                    return;
                }
                PhpPsiElement condition = expression.getCondition();
                PhpPsiElement variant = expression.getTrueVariant();
                if (condition == null || variant == null || expression.getFalseVariant() == null) {
                    return;
                }
                boolean sameElements = PhpPsiUtil.areElementsEquivalent(PhpPsiUtil.unparenthesize((PsiElement)condition), PhpPsiUtil.unparenthesize((PsiElement)variant));
                if (sameElements && !PhpSideEffectDetector.canContainSideEffect((PsiElement)condition)) {
                    holder.problem((PsiElement)variant, PhpBundle.message("inspection.message.can.be.removed", variant.getText())).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix((PsiElement)variant)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpTernaryExpressionCanBeReducedToShortVersionInspection", "buildVisitor"));
    }
}

