/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpToStringImplementationVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpToStringMethodsWithExceptionThrowIndex;
import org.jetbrains.annotations.NotNull;

public final class PhpToStringMayProduceExceptionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpToStringMayProduceExceptionInspection.$$$reportNull$$$0(0);
        }
        return new PhpToStringImplementationVisitor(){

            @Override
            protected void checkImplementation(@NotNull PsiElement toStringElement) {
                if (toStringElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                Project project = holder.getProject();
                PhpType type = this.getToStringElementType(toStringElement).global(project);
                if (type.isAmbiguous()) {
                    return;
                }
                String classFQNWithExceptionThrow = (String)ContainerUtil.find(type.getTypes(), classFQN -> PhpToStringMayProduceExceptionInspection.mayProduceExceptionThrow(project, classFQN));
                if (classFQNWithExceptionThrow != null) {
                    holder.registerProblem(toStringElement, PhpFrontBackBundle.message((String)"PhpLanguageFeature.exception.throw.from.toString", (Object[])new Object[]{classFQNWithExceptionThrow}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toStringElement", "com/jetbrains/php/lang/inspections/codeSmell/PhpToStringMayProduceExceptionInspection$1", "checkImplementation"));
            }
        };
    }

    private static boolean mayProduceExceptionThrow(Project project, String classFQN) {
        return !PhpType.isPrimitiveType(classFQN) && !PhpType.isPluralType(classFQN) && PhpToStringMethodsWithExceptionThrowIndex.hasToStringWithExceptionThrow(project, classFQN);
    }

    @Override
    protected boolean isLanguageLevelSupported(@NotNull Project project) {
        if (project == null) {
            PhpToStringMayProduceExceptionInspection.$$$reportNull$$$0(1);
        }
        return PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().compareTo((Enum)PhpLanguageLevel.PHP740) < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpToStringMayProduceExceptionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isLanguageLevelSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

