/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PhpTraitUsageOutsideUseInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpTraitUsageOutsideUseInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClassReference(ClassReference classReference) {
                PsiElement parent = classReference.getParent();
                if (parent instanceof PhpReference || parent instanceof PhpUse || parent instanceof PhpTraitUseRule) {
                    return;
                }
                if (PhpLangUtil.isClassNameSpecial(classReference.getName())) {
                    return;
                }
                Collection<PhpClass> classes = PhpIndex.getInstance(holder.getProject()).getAnyByFQN(classReference.getFQN());
                if (!classes.isEmpty() && ContainerUtil.and(classes, PhpClass::isTrait)) {
                    holder.registerProblem((PsiElement)classReference, PhpBundle.message("inspection.message.trait.usage", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpTraitUsageOutsideUseInspection", "buildVisitor"));
    }
}

