/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpPassByRefInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpDangerousArrayInitializationInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.PhpInlineVariableHandler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnnecessaryLocalVariableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpVariable(Variable variable) {
                if (!isOnTheFly) {
                    return;
                }
                AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)variable, AssignmentExpression.class);
                if (assignmentExpression != null && assignmentExpression.getVariable() == variable) {
                    return;
                }
                if (PhpLangUtil.isSuperGlobal(variable.getName()) || PhpLangUtil.isMagicPredefinedVariable(variable.getName())) {
                    return;
                }
                Variable resolvedVariable = (Variable)ObjectUtils.tryCast((Object)variable.resolve(), Variable.class);
                if (resolvedVariable == null) {
                    return;
                }
                if (PhpLangUtil.isThisReference((PsiElement)resolvedVariable)) {
                    return;
                }
                if (!PhpUnnecessaryLocalVariableInspection.isLocal((PsiElement)resolvedVariable)) {
                    return;
                }
                if (!PhpUnnecessaryLocalVariableInspection.hasOnlyOneUsage((PsiElement)resolvedVariable)) {
                    return;
                }
                holder.registerProblem((PsiElement)variable, PhpBundle.message("unnecessary.local.variable", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new PhpInlineVariableQuickFix(variable)});
            }

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                PhpPsiElement value;
                Function function;
                if (assignmentExpression instanceof SelfAssignmentExpression || !PhpUnnecessaryLocalVariableInspection.isSingleStatement(assignmentExpression)) {
                    return;
                }
                Variable variable = (Variable)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), Variable.class);
                if (variable == null || !variable.getDocType().isEmpty()) {
                    return;
                }
                if (PhpLangUtil.isSuperGlobal(variable.getName()) || PhpLangUtil.isMagicPredefinedVariable(variable.getName())) {
                    return;
                }
                PsiElement resolvedAssignmentVariable = variable.resolve();
                Parameter parameter = (Parameter)ObjectUtils.tryCast((Object)resolvedAssignmentVariable, Parameter.class);
                if (parameter != null && parameter.isPassByRef()) {
                    return;
                }
                if (resolvedAssignmentVariable == null || !PhpUnnecessaryLocalVariableInspection.isLocal(resolvedAssignmentVariable)) {
                    return;
                }
                if (resolvedAssignmentVariable instanceof Variable && PhpPsiUtil.getParentOfClass(resolvedAssignmentVariable, PhpStaticStatement.class) != null && PhpUnnecessaryLocalVariableInspection.this.variableReadAccessBeforeAssignmentExists((Variable)resolvedAssignmentVariable, variable)) {
                    return;
                }
                Variable nextExitInstructionArgumentVariable = PhpUnnecessaryLocalVariableInspection.getNextExitInstructionArgumentVariable((PsiElement)variable);
                if (nextExitInstructionArgumentVariable != null && nextExitInstructionArgumentVariable.getParent() instanceof PhpReturn && (function = PhpPsiUtil.getParentOfClass((PsiElement)nextExitInstructionArgumentVariable, Function.class)) != null && function.isReturningByReference() && ((value = assignmentExpression.getValue()) == null || !PhpPassByRefInspection.canBePassByReference((PsiElement)value))) {
                    return;
                }
                if (PhpUnnecessaryLocalVariableInspection.isImmediatelyUsedInExitInstruction(variable, nextExitInstructionArgumentVariable) && !PhpUnnecessaryLocalVariableInspection.this.followingVariableAccessExists(nextExitInstructionArgumentVariable)) {
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("unnecessary.local.variable", new Object[0]), new LocalQuickFix[]{new PhpInlineVariableQuickFix(variable)});
                } else if (isOnTheFly && parameter == null && PhpUnnecessaryLocalVariableInspection.hasOnlyOneUsage(resolvedAssignmentVariable)) {
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("unnecessary.local.variable", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new PhpInlineVariableQuickFix(variable)});
                }
            }
        };
    }

    private boolean followingVariableAccessExists(final @NotNull Variable variable) {
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(1);
        }
        final Ref res = new Ref((Object)false);
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName()) && instruction.getAnchor() != variable) {
                    res.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)res.get();
    }

    private boolean variableReadAccessBeforeAssignmentExists(Variable staticWriteVariable, final Variable variable) {
        PhpAccessVariableInstruction variableInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (variableInstruction == null) {
            return false;
        }
        PhpAccessVariableInstruction staticWriteVariableInstruction = PhpControlFlowUtil.getAccessInstruction(staticWriteVariable, PhpAccessVariableInstruction.class);
        if (staticWriteVariableInstruction == null) {
            return false;
        }
        final Ref variableAccessBeforeAssignmentExists = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(staticWriteVariableInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                    if (!instruction.getAccess().isWrite()) {
                        variableAccessBeforeAssignmentExists.set((Object)true);
                    }
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)variableAccessBeforeAssignmentExists.get();
    }

    private static boolean hasOnlyOneUsage(@NotNull PsiElement element) {
        PhpAccessVariableInstruction instruction;
        PhpPsiElement phpElement;
        if (element == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(2);
        }
        if ((phpElement = (PhpPsiElement)ObjectUtils.tryCast((Object)element, PhpPsiElement.class)) != null && PhpDangerousArrayInitializationInspection.isRepeatable(phpElement, PhpAccessVariableInstruction.class)) {
            return false;
        }
        PhpScopeHolder holder = PhpPsiUtil.getScopeHolder((PsiElement)phpElement);
        return holder != null && (instruction = holder.getControlFlow().getInstruction((PsiElement)phpElement, PhpAccessVariableInstruction.class)) != null && PhpUnnecessaryLocalVariableInspection.hasOnlyOneFollowingUsage(instruction);
    }

    private static boolean hasOnlyOneFollowingUsage(final PhpAccessVariableInstruction instruction) {
        final Ref first = new Ref((Object)false);
        final Ref second = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction i) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), i.getVariableName())) {
                    if (!((Boolean)first.get()).booleanValue()) {
                        first.set((Object)true);
                        return true;
                    }
                    second.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)first.get() != false && (Boolean)second.get() == false;
    }

    private static boolean isLocal(@NotNull PsiElement variable) {
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(3);
        }
        if (PhpPsiUtil.getParentOfClass(variable, Function.class) == null) {
            return false;
        }
        return !(variable.getParent() instanceof Global);
    }

    private static boolean isExitStatement(StatementWithArgument s) {
        return s instanceof PhpReturn || s.getFirstChild() instanceof PhpThrowExpression || s instanceof PhpYield;
    }

    private static boolean isSingleStatement(AssignmentExpression parentAssignmentExpression) {
        PsiElement parentStatement = parentAssignmentExpression.getParent();
        if (!(parentStatement instanceof Statement)) {
            return false;
        }
        PsiElement[] children = parentStatement.getChildren();
        return children.length == 1 && children[0] == parentAssignmentExpression;
    }

    @Nullable
    private static Variable getNextExitInstructionArgumentVariable(@NotNull PsiElement variable) {
        Statement statement;
        StatementWithArgument nextStatementWithArgument;
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(4);
        }
        if ((nextStatementWithArgument = PhpUnnecessaryLocalVariableInspection.getNextStatementWithArgument((PsiElement)(statement = PhpPsiUtil.getParentOfClass(variable, Statement.class)))) == null || !PhpUnnecessaryLocalVariableInspection.isExitStatement(nextStatementWithArgument)) {
            return null;
        }
        return (Variable)ObjectUtils.tryCast((Object)nextStatementWithArgument.getArgument(), Variable.class);
    }

    @Nullable
    private static StatementWithArgument getNextStatementWithArgument(@Nullable PsiElement statement) {
        if (statement == null) {
            return null;
        }
        while ((statement = statement.getNextSibling()) instanceof PsiWhiteSpace || statement instanceof PsiComment) {
        }
        if (statement instanceof StatementWithArgument) {
            return (StatementWithArgument)statement;
        }
        if (statement instanceof StatementImpl && statement.getChildren().length == 1) {
            return (StatementWithArgument)ObjectUtils.tryCast((Object)statement.getChildren()[0], StatementWithArgument.class);
        }
        return null;
    }

    private static boolean isImmediatelyUsedInExitInstruction(@NotNull Variable variable, Variable exitInstructionArgumentVariable) {
        if (variable == null) {
            PhpUnnecessaryLocalVariableInspection.$$$reportNull$$$0(5);
        }
        return exitInstructionArgumentVariable != null && PhpLangUtil.equalsClassNames(exitInstructionArgumentVariable.getName(), variable.getName()) && PhpUnnecessaryLocalVariableInspection.isResolvedToVariable(exitInstructionArgumentVariable, variable);
    }

    private static boolean isResolvedToVariable(Variable exitInstructionArgumentVariable, final Variable variable) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(exitInstructionArgumentVariable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        final Ref res = new Ref((Object)true);
        PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    if (instruction.getAnchor() != variable) {
                        res.set((Object)true);
                    }
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)res.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "followingVariableAccessExists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasOnlyOneUsage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNextExitInstructionArgumentVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImmediatelyUsedInExitInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpInlineVariableQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpInlineVariableQuickFix(Variable variable) {
            super((PsiElement)variable);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Variable variable;
            if (project == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(4);
            }
            if ((variable = (Variable)ObjectUtils.tryCast((Object)this.myStartElement.getElement(), Variable.class)) == null) {
                return;
            }
            try {
                PhpInlineVariableHandler.invoke(project, null, variable);
            }
            catch (PhpRefactoringErrorException phpRefactoringErrorException) {
                // empty catch block
            }
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.inline.variable.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpInlineVariableQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection$PhpInlineVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryLocalVariableInspection$PhpInlineVariableQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

