/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayMapCanBeConvertedToLoopInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayFilterToLoopQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpArrayFilterCanBeConvertedToLoopInspection
extends PhpInspection {
    public static boolean canBeCalledAsLambda(PsiElement element) {
        return element instanceof Variable || element instanceof StringLiteralExpression;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayFilterCanBeConvertedToLoopInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference arrayFilterCall) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(arrayFilterCall, "array_filter")) {
                    return;
                }
                PsiElement argument = arrayFilterCall.getParameter(1);
                if (argument == null) {
                    return;
                }
                Function closure = (Function)PhpPsiUtil.getChildByCondition(argument, Function.INSTANCEOF);
                if (PhpArrayFilterCanBeConvertedToLoopInspection.canBeCalledAsLambda(argument) || closure != null && PhpArrayMapCanBeConvertedToLoopInspection.hasNoUseByReferences(closure) && PsiTreeUtil.findChildrenOfType((PsiElement)closure, PhpReturn.class).size() == 1) {
                    holder.registerProblem(arrayFilterCall.getFirstChild(), PhpBundle.message("inspection.arrayfilter.can.be.converted.to.loop", new Object[0]), new LocalQuickFix[]{PhpConvertArrayFilterToLoopQuickFix.INSTANCE});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayFilterCanBeConvertedToLoopInspection", "buildVisitor"));
    }
}

