/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"isValidArrayCheckFunctionClosure", "", "arrayCheckFunctionCall", "Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "isProperlyDefinedClosure", "closure", "Lcom/jetbrains/php/lang/psi/elements/Function;", "canBeCalledAsLambda", "element", "Lcom/intellij/psi/PsiElement;", "intellij.php.impl"})
public final class PhpArrayFindCanBeConvertedToLoopInspectionKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidArrayCheckFunctionClosure(@NotNull FunctionReference arrayCheckFunctionCall) {
        Intrinsics.checkNotNullParameter((Object)arrayCheckFunctionCall, (String)"arrayCheckFunctionCall");
        PsiElement[] psiElementArray = arrayCheckFunctionCall.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
        PsiElement[] arguments = psiElementArray;
        if (arguments.length != 2) {
            return false;
        }
        PsiElement secondArgument = arguments[1];
        Function function = (Function)PhpPsiUtil.getChildByCondition(secondArgument, Function.INSTANCEOF);
        if (PhpArrayFindCanBeConvertedToLoopInspectionKt.canBeCalledAsLambda(secondArgument)) return true;
        if (function == null) return false;
        PhpTypedElement phpTypedElement = secondArgument instanceof PhpTypedElement ? (PhpTypedElement)secondArgument : null;
        if (!Intrinsics.areEqual((Object)(phpTypedElement != null ? phpTypedElement.getType() : null), (Object)PhpType.CLOSURE)) return false;
        if (!PhpArrayFindCanBeConvertedToLoopInspectionKt.isProperlyDefinedClosure(function)) return false;
        return true;
    }

    private static final boolean isProperlyDefinedClosure(Function closure) {
        return closure.getParameters().length <= 2 && PsiTreeUtil.findChildrenOfType((PsiElement)closure, PhpReturn.class).size() == 1;
    }

    private static final boolean canBeCalledAsLambda(PsiElement element) {
        return element instanceof StringLiteralExpression;
    }
}

