/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpArrayFindCanBeConvertedToLoopInspectionKt;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseConvertArrayCheckFunctionToLoopQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpArrayFindKeyCanBeConvertedToLoopInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "Companion", "PhpConvertArrayFindKeyToLoopQuickFix", "intellij.php.impl"})
public final class PhpArrayFindKeyCanBeConvertedToLoopInspection
extends PhpInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ARRAY_FIND_KEY_FUNCTION = "array_find_key";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpFunctionCall(FunctionReference arrayFindKeyCall) {
                Intrinsics.checkNotNullParameter((Object)arrayFindKeyCall, (String)"arrayFindKeyCall");
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(arrayFindKeyCall, "array_find_key")) {
                    return;
                }
                if (!PhpArrayFindCanBeConvertedToLoopInspectionKt.isValidArrayCheckFunctionClosure(arrayFindKeyCall)) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpConvertArrayFindKeyToLoopQuickFix.INSTANCE};
                this.$holder.registerProblem((PsiElement)arrayFindKeyCall, PhpBundle.message("inspection.arrayfindkey.can.be.converted.to.loop", new Object[0]), localQuickFixArray);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpArrayFindKeyCanBeConvertedToLoopInspection$Companion;", "", "<init>", "()V", "ARRAY_FIND_KEY_FUNCTION", "", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpArrayFindKeyCanBeConvertedToLoopInspection$PhpConvertArrayFindKeyToLoopQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertArrayCheckFunctionToLoopQuickFix;", "<init>", "()V", "getReturnArgumentInForeach", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertArrayCheckFunctionToLoopQuickFix$AllowedReturnArgument;", "keyName", "", "valueName", "getOuterReturnArgument", "getFamilyName", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpArrayFindKeyCanBeConvertedToLoopInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpArrayFindKeyCanBeConvertedToLoopInspection.kt\ncom/jetbrains/php/lang/inspections/codeStyle/PhpArrayFindKeyCanBeConvertedToLoopInspection$PhpConvertArrayFindKeyToLoopQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
    public static final class PhpConvertArrayFindKeyToLoopQuickFix
    extends PhpBaseConvertArrayCheckFunctionToLoopQuickFix {
        @NotNull
        public static final PhpConvertArrayFindKeyToLoopQuickFix INSTANCE = new PhpConvertArrayFindKeyToLoopQuickFix();

        private PhpConvertArrayFindKeyToLoopQuickFix() {
        }

        @Override
        @NotNull
        public PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument getReturnArgumentInForeach(@Nullable String keyName, @NotNull String valueName) {
            PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument allowedReturnArgument;
            Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
            String string = keyName;
            if (string != null) {
                String it = string;
                boolean bl = false;
                allowedReturnArgument = new PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument.KEY(it);
            } else {
                allowedReturnArgument = PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument.NULL.INSTANCE;
            }
            return allowedReturnArgument;
        }

        @Override
        @NotNull
        public PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument getOuterReturnArgument(@Nullable String keyName, @NotNull String valueName) {
            Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
            return PhpBaseConvertArrayCheckFunctionToLoopQuickFix.AllowedReturnArgument.NULL.INSTANCE;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.convert.arrayfindkey.to.loop", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

