/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpReplaceWithElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpParameterType;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpArrayTraversableCanBeReplacedWithIterableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayTraversableCanBeReplacedWithIterableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpReturnType(PhpReturnType returnType) {
                this.checkIfCanBeReplacedWithIterable(returnType);
            }

            @Override
            public void visitPhpParameterTypeDeclaration(PhpParameterType parameterTypeDeclaration) {
                this.checkIfCanBeReplacedWithIterable(parameterTypeDeclaration);
            }

            private void checkIfCanBeReplacedWithIterable(PhpTypeDeclaration typeDeclaration) {
                if (PhpType.intersects(PhpType.ARRAY, typeDeclaration.getDeclaredType()) && PhpType.intersects(PhpType.TRAVERSABLE, typeDeclaration.getDeclaredType())) {
                    holder.problem((PsiElement)typeDeclaration, PhpBundle.message("inspection.message.array.traversable.can.be.replaced.with.iterable", new Object[0])).fix((ModCommandAction)new PhpReplaceArrayTraversableWithIterableQuickFix(typeDeclaration)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayTraversableCanBeReplacedWithIterableInspection", "buildVisitor"));
    }

    private static class PhpReplaceArrayTraversableWithIterableQuickFix
    extends PhpReplaceWithElementQuickFix {
        private PhpReplaceArrayTraversableWithIterableQuickFix(PhpTypeDeclaration typeDeclarationToReplace) {
            super((PsiElement)typeDeclarationToReplace, (PsiElement)typeDeclarationToReplace, PhpBundle.message("intention.family.name.replace.array.traversable.with.iterable", new Object[0]));
        }

        @Override
        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpTypeDeclaration typeDeclaration;
            if (context == null) {
                PhpReplaceArrayTraversableWithIterableQuickFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceArrayTraversableWithIterableQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpReplaceArrayTraversableWithIterableQuickFix.$$$reportNull$$$0(2);
            }
            if ((typeDeclaration = (PhpTypeDeclaration)ObjectUtils.tryCast((Object)element, PhpTypeDeclaration.class)) == null) {
                return;
            }
            PhpType type = typeDeclaration.getDeclaredType();
            type = type.filterOut(t -> "\\array".equals(t) || "\\Traversable".equals(t));
            type.add(PhpType.ITERABLE);
            typeDeclaration.update(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updater";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpArrayTraversableCanBeReplacedWithIterableInspection$PhpReplaceArrayTraversableWithIterableQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

